/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.Asset;

public class FullAddressTransactions {
    @SerializedName(value="confirmed")
    private Integer confirmed = null;
    @SerializedName(value="totalReceived")
    private Integer totalReceived = null;
    @SerializedName(value="confirmedBalance")
    private Integer confirmedBalance = null;
    @SerializedName(value="totalBalance")
    private Integer totalBalance = null;
    @SerializedName(value="confirmedTokensBalance")
    private List<Asset> confirmedTokensBalance = null;
    @SerializedName(value="totalTokensBalance")
    private List<Asset> totalTokensBalance = null;

    public FullAddressTransactions confirmed(Integer n) {
        this.confirmed = n;
        return this;
    }

    @Schema(example="2341", required=true, description="Total number of confirmed transactions")
    public Integer getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Integer n) {
        this.confirmed = n;
    }

    public FullAddressTransactions totalReceived(Integer n) {
        this.totalReceived = n;
        return this;
    }

    @Schema(example="10455323", description="Total recieved coins")
    public Integer getTotalReceived() {
        return this.totalReceived;
    }

    public void setTotalReceived(Integer n) {
        this.totalReceived = n;
    }

    public FullAddressTransactions confirmedBalance(Integer n) {
        this.confirmedBalance = n;
        return this;
    }

    @Schema(example="1123", description="Confirmed balance")
    public Integer getConfirmedBalance() {
        return this.confirmedBalance;
    }

    public void setConfirmedBalance(Integer n) {
        this.confirmedBalance = n;
    }

    public FullAddressTransactions totalBalance(Integer n) {
        this.totalBalance = n;
        return this;
    }

    @Schema(example="1123", description="Total balance including off-chain transactions")
    public Integer getTotalBalance() {
        return this.totalBalance;
    }

    public void setTotalBalance(Integer n) {
        this.totalBalance = n;
    }

    public FullAddressTransactions confirmedTokensBalance(List<Asset> list) {
        this.confirmedTokensBalance = list;
        return this;
    }

    public FullAddressTransactions addConfirmedTokensBalanceItem(Asset asset) {
        if (this.confirmedTokensBalance == null) {
            this.confirmedTokensBalance = new ArrayList<Asset>();
        }
        this.confirmedTokensBalance.add(asset);
        return this;
    }

    @Schema(description="Confirmed tokens balance")
    public List<Asset> getConfirmedTokensBalance() {
        return this.confirmedTokensBalance;
    }

    public void setConfirmedTokensBalance(List<Asset> list) {
        this.confirmedTokensBalance = list;
    }

    public FullAddressTransactions totalTokensBalance(List<Asset> list) {
        this.totalTokensBalance = list;
        return this;
    }

    public FullAddressTransactions addTotalTokensBalanceItem(Asset asset) {
        if (this.totalTokensBalance == null) {
            this.totalTokensBalance = new ArrayList<Asset>();
        }
        this.totalTokensBalance.add(asset);
        return this;
    }

    @Schema(description="Total tokens balance including off-chain transactions")
    public List<Asset> getTotalTokensBalance() {
        return this.totalTokensBalance;
    }

    public void setTotalTokensBalance(List<Asset> list) {
        this.totalTokensBalance = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FullAddressTransactions fullAddressTransactions = (FullAddressTransactions)object;
        return Objects.equals(this.confirmed, fullAddressTransactions.confirmed) && Objects.equals(this.totalReceived, fullAddressTransactions.totalReceived) && Objects.equals(this.confirmedBalance, fullAddressTransactions.confirmedBalance) && Objects.equals(this.totalBalance, fullAddressTransactions.totalBalance) && Objects.equals(this.confirmedTokensBalance, fullAddressTransactions.confirmedTokensBalance) && Objects.equals(this.totalTokensBalance, fullAddressTransactions.totalTokensBalance);
    }

    public int hashCode() {
        return Objects.hash(this.confirmed, this.totalReceived, this.confirmedBalance, this.totalBalance, this.confirmedTokensBalance, this.totalTokensBalance);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FullAddressTransactions {\n");
        stringBuilder.append("    confirmed: ").append(this.toIndentedString(this.confirmed)).append("\n");
        stringBuilder.append("    totalReceived: ").append(this.toIndentedString(this.totalReceived)).append("\n");
        stringBuilder.append("    confirmedBalance: ").append(this.toIndentedString(this.confirmedBalance)).append("\n");
        stringBuilder.append("    totalBalance: ").append(this.toIndentedString(this.totalBalance)).append("\n");
        stringBuilder.append("    confirmedTokensBalance: ").append(this.toIndentedString(this.confirmedTokensBalance)).append("\n");
        stringBuilder.append("    totalTokensBalance: ").append(this.toIndentedString(this.totalTokensBalance)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

