/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;

public class WalletBox {
    @SerializedName(value="box")
    private ErgoTransactionOutput box = null;
    @SerializedName(value="confirmationsNum")
    private Integer confirmationsNum = null;
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="creationTransaction")
    private String creationTransaction = null;
    @SerializedName(value="spendingTransaction")
    private String spendingTransaction = null;
    @SerializedName(value="spendingHeight")
    private Integer spendingHeight = null;
    @SerializedName(value="inclusionHeight")
    private Integer inclusionHeight = null;
    @SerializedName(value="certain")
    private Boolean certain = null;
    @SerializedName(value="onchain")
    private Boolean onchain = null;
    @SerializedName(value="spent")
    private Boolean spent = null;
    @SerializedName(value="creationOutIndex")
    private Integer creationOutIndex = null;
    @SerializedName(value="applicationId")
    private Integer applicationId = 1;

    public WalletBox box(ErgoTransactionOutput ergoTransactionOutput) {
        this.box = ergoTransactionOutput;
        return this;
    }

    @Schema(required=true, description="")
    public ErgoTransactionOutput getBox() {
        return this.box;
    }

    public void setBox(ErgoTransactionOutput ergoTransactionOutput) {
        this.box = ergoTransactionOutput;
    }

    public WalletBox confirmationsNum(Integer n) {
        this.confirmationsNum = n;
        return this;
    }

    @Schema(example="147", required=true, description="Age of box in blocks")
    public Integer getConfirmationsNum() {
        return this.confirmationsNum;
    }

    public void setConfirmationsNum(Integer n) {
        this.confirmationsNum = n;
    }

    public WalletBox address(String string) {
        this.address = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public WalletBox creationTransaction(String string) {
        this.creationTransaction = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getCreationTransaction() {
        return this.creationTransaction;
    }

    public void setCreationTransaction(String string) {
        this.creationTransaction = string;
    }

    public WalletBox spendingTransaction(String string) {
        this.spendingTransaction = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getSpendingTransaction() {
        return this.spendingTransaction;
    }

    public void setSpendingTransaction(String string) {
        this.spendingTransaction = string;
    }

    public WalletBox spendingHeight(Integer n) {
        this.spendingHeight = n;
        return this;
    }

    @Schema(example="147", required=true, description="The height the box was spent at")
    public Integer getSpendingHeight() {
        return this.spendingHeight;
    }

    public void setSpendingHeight(Integer n) {
        this.spendingHeight = n;
    }

    public WalletBox inclusionHeight(Integer n) {
        this.inclusionHeight = n;
        return this;
    }

    @Schema(example="147", required=true, description="The height the transaction containing the box was included in a block at")
    public Integer getInclusionHeight() {
        return this.inclusionHeight;
    }

    public void setInclusionHeight(Integer n) {
        this.inclusionHeight = n;
    }

    public WalletBox certain(Boolean bl) {
        this.certain = bl;
        return this;
    }

    @Schema(example="true", required=true, description="A flag signalling wheatehr the box is certainly resolved (as belonging to a wallet)")
    public Boolean isCertain() {
        return this.certain;
    }

    public void setCertain(Boolean bl) {
        this.certain = bl;
    }

    public WalletBox onchain(Boolean bl) {
        this.onchain = bl;
        return this;
    }

    @Schema(example="true", required=true, description="A flag signalling wheatehr the box is created on main chain")
    public Boolean isOnchain() {
        return this.onchain;
    }

    public void setOnchain(Boolean bl) {
        this.onchain = bl;
    }

    public WalletBox spent(Boolean bl) {
        this.spent = bl;
        return this;
    }

    @Schema(example="false", required=true, description="A flag signalling wheatehr the box was spent")
    public Boolean isSpent() {
        return this.spent;
    }

    public void setSpent(Boolean bl) {
        this.spent = bl;
    }

    public WalletBox creationOutIndex(Integer n) {
        this.creationOutIndex = n;
        return this;
    }

    @Schema(example="2", required=true, description="An index of a box in transaction")
    public Integer getCreationOutIndex() {
        return this.creationOutIndex;
    }

    public void setCreationOutIndex(Integer n) {
        this.creationOutIndex = n;
    }

    public WalletBox applicationId(Integer n) {
        this.applicationId = n;
        return this;
    }

    @Schema(example="1", required=true, description="Application identifier a box relates to")
    public Integer getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(Integer n) {
        this.applicationId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WalletBox walletBox = (WalletBox)object;
        return Objects.equals(this.box, walletBox.box) && Objects.equals(this.confirmationsNum, walletBox.confirmationsNum) && Objects.equals(this.address, walletBox.address) && Objects.equals(this.creationTransaction, walletBox.creationTransaction) && Objects.equals(this.spendingTransaction, walletBox.spendingTransaction) && Objects.equals(this.spendingHeight, walletBox.spendingHeight) && Objects.equals(this.inclusionHeight, walletBox.inclusionHeight) && Objects.equals(this.certain, walletBox.certain) && Objects.equals(this.onchain, walletBox.onchain) && Objects.equals(this.spent, walletBox.spent) && Objects.equals(this.creationOutIndex, walletBox.creationOutIndex) && Objects.equals(this.applicationId, walletBox.applicationId);
    }

    public int hashCode() {
        return Objects.hash(this.box, this.confirmationsNum, this.address, this.creationTransaction, this.spendingTransaction, this.spendingHeight, this.inclusionHeight, this.certain, this.onchain, this.spent, this.creationOutIndex, this.applicationId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class WalletBox {\n");
        stringBuilder.append("    box: ").append(this.toIndentedString(this.box)).append("\n");
        stringBuilder.append("    confirmationsNum: ").append(this.toIndentedString(this.confirmationsNum)).append("\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    creationTransaction: ").append(this.toIndentedString(this.creationTransaction)).append("\n");
        stringBuilder.append("    spendingTransaction: ").append(this.toIndentedString(this.spendingTransaction)).append("\n");
        stringBuilder.append("    spendingHeight: ").append(this.toIndentedString(this.spendingHeight)).append("\n");
        stringBuilder.append("    inclusionHeight: ").append(this.toIndentedString(this.inclusionHeight)).append("\n");
        stringBuilder.append("    certain: ").append(this.toIndentedString(this.certain)).append("\n");
        stringBuilder.append("    onchain: ").append(this.toIndentedString(this.onchain)).append("\n");
        stringBuilder.append("    spent: ").append(this.toIndentedString(this.spent)).append("\n");
        stringBuilder.append("    creationOutIndex: ").append(this.toIndentedString(this.creationOutIndex)).append("\n");
        stringBuilder.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

