/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxSelectorsJavaHelpers;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoContracts;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;

public class BoxOperations {
    public static List<InputBox> selectTop(List<InputBox> list, long l) {
        return BoxOperations.selectTop(list, l, new ArrayList<ErgoToken>());
    }

    public static List<InputBox> selectTop(List<InputBox> list, long l, List<ErgoToken> list2) {
        List<InputBox> list3 = BoxSelectorsJavaHelpers.selectBoxes(list, l, list2);
        return list3;
    }

    public static ErgoProver createProver(BlockchainContext blockchainContext, Mnemonic mnemonic) {
        ErgoProver ergoProver = blockchainContext.newProverBuilder().withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword()).build();
        return ergoProver;
    }

    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, SecretString secretString) {
        return BoxOperations.createProver(blockchainContext, string, secretString.toStringUnsecure());
    }

    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, String string2) {
        SecretStorage secretStorage = SecretStorage.loadFrom(string);
        secretStorage.unlock(string2);
        ErgoProverBuilder ergoProverBuilder = blockchainContext.newProverBuilder().withSecretStorage(secretStorage);
        return ergoProverBuilder;
    }

    public static String send(BlockchainContext blockchainContext, ErgoProver ergoProver, boolean bl, Address address, long l) {
        ErgoContract ergoContract = ErgoContracts.sendToPK(blockchainContext, address);
        SignedTransaction signedTransaction = BoxOperations.putToContractTx(blockchainContext, ergoProver, bl, ergoContract, l);
        blockchainContext.sendTransaction(signedTransaction);
        return signedTransaction.toJson(true);
    }

    public static List<InputBox> loadTop(BlockchainContext blockchainContext, Address address, long l) {
        List<InputBox> list = blockchainContext.getUnspentBoxesFor(address);
        List<InputBox> list2 = BoxOperations.selectTop(list, l);
        return list2;
    }

    public static List<InputBox> loadTop(BlockchainContext blockchainContext, List<Address> list, long l) {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        for (Address address : list) {
            List<InputBox> list2 = blockchainContext.getUnspentBoxesFor(address);
            arrayList.addAll(list2);
        }
        List<InputBox> list3 = BoxOperations.selectTop(arrayList, l);
        return list3;
    }

    public static SignedTransaction putToContractTx(BlockchainContext blockchainContext, ErgoProver ergoProver, boolean bl, ErgoContract ergoContract, long l) {
        List<Object> list;
        ArrayList<Address> arrayList = new ArrayList<Address>();
        if (bl) {
            list = ergoProver.getEip3Addresses();
            Preconditions.checkState((list.size() > 0 ? 1 : 0) != 0, (Object)"EIP-3 addresses are not derived in the prover (use ErgoProverBuilder.withEip3Secret)");
            arrayList.addAll(list);
        } else {
            arrayList.add(ergoProver.getAddress());
        }
        list = BoxOperations.loadTop(blockchainContext, arrayList, l + 1000000L);
        P2PKAddress p2PKAddress = bl ? ergoProver.getEip3Addresses().get(0).asP2PK() : ergoProver.getP2PKAddress();
        UnsignedTransactionBuilder unsignedTransactionBuilder = blockchainContext.newTxBuilder();
        OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(ergoContract).build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list).outputs(outBox).fee(1000000L).sendChangeTo((ErgoAddress)p2PKAddress).build();
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        return signedTransaction;
    }

    public static SignedTransaction spendBoxesTx(BlockchainContext blockchainContext, UnsignedTransactionBuilder unsignedTransactionBuilder, List<InputBox> list, ErgoProver ergoProver, Address address, long l, long l2) {
        OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(ErgoContracts.sendToPK(blockchainContext, address)).build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list).outputs(outBox).fee(l2).sendChangeTo((ErgoAddress)ergoProver.getP2PKAddress()).build();
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        return signedTransaction;
    }
}

