/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ergoplatform.ApiTestBase;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.CoveringBoxes;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.PowSolutions;
import org.ergoplatform.restapi.client.Registers;
import org.junit.Assert;
import org.junit.Test;

public class BlockchainContextImplTest
extends ApiTestBase {
    @Test
    public void getCoveringBoxesForTest() {
        MockedBlockChainContextImpl mockedBlockChainContextImpl = new MockedBlockChainContextImpl();
        CoveringBoxes coveringBoxes = mockedBlockChainContextImpl.getCoveringBoxesFor(Address.create((String)this.address), 1000000000L, new ArrayList());
        Assert.assertFalse((boolean)coveringBoxes.isCovered());
        InputBoxImpl inputBoxImpl = new InputBoxImpl((BlockchainContextBase)mockedBlockChainContextImpl, this.getMockBox(1000000000L));
        mockedBlockChainContextImpl.unspentBoxesMock.add((InputBox)inputBoxImpl);
        coveringBoxes = mockedBlockChainContextImpl.getCoveringBoxesFor(Address.create((String)this.address), 1000000000L, new ArrayList());
        Assert.assertTrue((boolean)coveringBoxes.isCovered());
        coveringBoxes = mockedBlockChainContextImpl.getCoveringBoxesFor(Address.create((String)this.address), 2000000000L, new ArrayList());
        Assert.assertFalse((boolean)coveringBoxes.isCovered());
        mockedBlockChainContextImpl.unspentBoxesMock.add((InputBox)inputBoxImpl);
        coveringBoxes = mockedBlockChainContextImpl.getCoveringBoxesFor(Address.create((String)this.address), 2000000000L, new ArrayList());
        Assert.assertFalse((boolean)coveringBoxes.isCovered());
    }

    private ErgoTransactionOutput getMockBox(long l) {
        ErgoTransactionOutput ergoTransactionOutput = new ErgoTransactionOutput();
        ergoTransactionOutput.boxId(this.boxId).ergoTree(this.ergoTree).assets(new ArrayList()).additionalRegisters(new Registers()).index(Integer.valueOf(10)).value(Long.valueOf(l)).creationHeight(Integer.valueOf(667));
        return ergoTransactionOutput;
    }

    private List<BlockHeader> getMockHeader() {
        ArrayList<BlockHeader> arrayList = new ArrayList<BlockHeader>();
        PowSolutions powSolutions = new PowSolutions();
        powSolutions.setPk("03224c2f2388ae0741be2c50727caa49bd62654dc1f36ee72392b187b78da2c717");
        powSolutions.w("0279be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798");
        powSolutions.n("20d68047ea27a031");
        powSolutions.d(BigInteger.ZERO);
        BlockHeader blockHeader = new BlockHeader().height(Integer.valueOf(667)).nBits(Long.valueOf(19857408L)).difficulty(BigInteger.TEN).id(this.blockId).parentId(this.blockId).adProofsRoot(this.blockId).stateRoot(this.blockId).transactionsRoot(this.blockId).version(Integer.valueOf(2)).extensionHash(this.blockId).powSolutions(powSolutions).timestamp(Long.valueOf(0L)).votes("0279be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798");
        arrayList.add(blockHeader);
        return arrayList;
    }

    class MockedBlockChainContextImpl
    extends BlockchainContextImpl {
        List<InputBox> unspentBoxesMock;

        public MockedBlockChainContextImpl() {
            super(null, null, null, null, NetworkType.MAINNET, null, BlockchainContextImplTest.this.getMockHeader());
            this.unspentBoxesMock = new ArrayList<InputBox>();
        }

        public List<InputBox> getUnspentBoxesFor(Address address, int n, int n2) {
            if (n >= n2) {
                return Collections.emptyList();
            }
            return this.unspentBoxesMock;
        }
    }
}

