/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.io.IOException;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.FeeHistogram;
import org.ergoplatform.restapi.client.PeerFinder;
import org.ergoplatform.restapi.client.Transactions;
import org.ergoplatform.restapi.client.TransactionsApi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionsApiTest
extends PeerFinder {
    private TransactionsApi api;

    @Before
    public void setup() {
        this.api = (TransactionsApi)this.findPeer(true).createService(TransactionsApi.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkTransactionTest() throws IOException {
        ErgoTransaction ergoTransaction = null;
        String string = (String)this.api.checkTransaction(ergoTransaction).execute().body();
    }

    @Test
    public void getExpectedWaitTimeTest() throws IOException {
        Integer n = 1000000;
        Integer n2 = 1000;
        Integer n3 = (Integer)this.api.getExpectedWaitTime(n, n2).execute().body();
        Assert.assertNotNull((Object)n3);
        Assert.assertTrue((n3 == 0 ? 1 : 0) != 0);
    }

    @Test
    public void getFeeHistogramTest() throws IOException {
        Integer n = 10;
        Long l = 1000L;
        FeeHistogram feeHistogram = (FeeHistogram)this.api.getFeeHistogram(n, l).execute().body();
        Assert.assertNotNull((Object)feeHistogram);
        Assert.assertTrue((feeHistogram.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getRecommendedFeeTest() throws IOException {
        Integer n = 10;
        Integer n2 = 1000;
        Integer n3 = (Integer)this.api.getRecommendedFee(n, n2).execute().body();
        Assert.assertNotNull((Object)n3);
        Assert.assertTrue((n3 > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getUnconfirmedTransactionsTest() throws IOException {
        Integer n = 10;
        Integer n2 = 1;
        Transactions transactions = (Transactions)this.api.getUnconfirmedTransactions(n, n2).execute().body();
        Assert.assertNotNull((Object)transactions);
        Assert.assertTrue((transactions.size() >= 0 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sendTransactionTest() throws IOException {
        ErgoTransaction ergoTransaction = null;
        String string = (String)this.api.sendTransaction(ergoTransaction).execute().body();
    }
}

