/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxSelectorsJavaHelpers;
import org.ergoplatform.appkit.CoveringBoxes;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.appkit.SelectTokensHelper;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.impl.ErgoTreeContract;

public class BoxOperations {
    public static List<InputBox> selectTop(List<InputBox> list, long l) {
        return BoxOperations.selectTop(list, l, new ArrayList<ErgoToken>());
    }

    public static List<InputBox> selectTop(List<InputBox> list, long l, List<ErgoToken> list2) {
        List<InputBox> list3 = BoxSelectorsJavaHelpers.selectBoxes(list, l, list2);
        return list3;
    }

    public static ErgoProver createProver(BlockchainContext blockchainContext, Mnemonic mnemonic) {
        ErgoProver ergoProver = blockchainContext.newProverBuilder().withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword()).build();
        return ergoProver;
    }

    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, SecretString secretString) {
        return BoxOperations.createProver(blockchainContext, string, secretString.toStringUnsecure());
    }

    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, String string2) {
        SecretStorage secretStorage = SecretStorage.loadFrom(string);
        secretStorage.unlock(string2);
        ErgoProverBuilder ergoProverBuilder = blockchainContext.newProverBuilder().withSecretStorage(secretStorage);
        return ergoProverBuilder;
    }

    public static String send(BlockchainContext blockchainContext, ErgoProver ergoProver, boolean bl, Address address, long l) {
        ErgoTreeContract ergoTreeContract = new ErgoTreeContract(address.getErgoAddress().script());
        SignedTransaction signedTransaction = BoxOperations.putToContractTx(blockchainContext, ergoProver, bl, ergoTreeContract, l, new ArrayList<ErgoToken>());
        blockchainContext.sendTransaction(signedTransaction);
        return signedTransaction.toJson(true);
    }

    public static List<InputBox> loadTop(BlockchainContext blockchainContext, Address address, long l, List<ErgoToken> list) {
        CoveringBoxes coveringBoxes = blockchainContext.getCoveringBoxesFor(address, l, list);
        List<InputBox> list2 = BoxOperations.selectTop(coveringBoxes.getBoxes(), l, list);
        return list2;
    }

    public static List<InputBox> loadTop(BlockchainContext blockchainContext, List<Address> list, long l, List<ErgoToken> list2) {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = l;
        SelectTokensHelper selectTokensHelper = new SelectTokensHelper(list2);
        List<ErgoToken> list3 = list2;
        for (Address address : list) {
            CoveringBoxes coveringBoxes = blockchainContext.getCoveringBoxesFor(address, l2, list3);
            for (InputBox inputBox : coveringBoxes.getBoxes()) {
                arrayList.add(inputBox);
                selectTokensHelper.foundNewTokens(inputBox.getTokens());
                if ((l2 -= inputBox.getValue().longValue()) > 0L || !selectTokensHelper.areTokensCovered()) continue;
                break;
            }
            if (l2 <= 0L && selectTokensHelper.areTokensCovered()) break;
            list3 = selectTokensHelper.getRemainingTokenList();
        }
        List<InputBox> list4 = BoxOperations.selectTop(arrayList, l, list2);
        return list4;
    }

    public static SignedTransaction putToContractTx(BlockchainContext blockchainContext, ErgoProver ergoProver, boolean bl, ErgoContract ergoContract, long l, List<ErgoToken> list) {
        UnsignedTransaction unsignedTransaction = BoxOperations.putToContractTxUnsigned(blockchainContext, ergoProver, bl, ergoContract, l, list);
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        return signedTransaction;
    }

    public static UnsignedTransaction putToContractTxUnsigned(BlockchainContext blockchainContext, ErgoProver ergoProver, boolean bl, ErgoContract ergoContract, long l, List<ErgoToken> list) {
        ArrayList<Address> arrayList = new ArrayList<Address>();
        if (bl) {
            List<Address> list2 = ergoProver.getEip3Addresses();
            Preconditions.checkState((list2.size() > 0 ? 1 : 0) != 0, (Object)"EIP-3 addresses are not derived in the prover (use ErgoProverBuilder.withEip3Secret)");
            arrayList.addAll(list2);
        } else {
            arrayList.add(ergoProver.getAddress());
        }
        return BoxOperations.putToContractTxUnsigned(blockchainContext, arrayList, ergoContract, l, list);
    }

    public static UnsignedTransaction putToContractTxUnsigned(BlockchainContext blockchainContext, List<Address> list, ErgoContract ergoContract, long l, List<ErgoToken> list2) {
        List<InputBox> list3 = BoxOperations.loadTop(blockchainContext, list, l + 1000000L, list2);
        P2PKAddress p2PKAddress = list.get(0).asP2PK();
        UnsignedTransactionBuilder unsignedTransactionBuilder = blockchainContext.newTxBuilder();
        OutBoxBuilder outBoxBuilder = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(ergoContract);
        if (!list2.isEmpty()) {
            outBoxBuilder.tokens(list2.toArray(new ErgoToken[0]));
        }
        OutBox outBox = outBoxBuilder.build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list3).outputs(outBox).fee(1000000L).sendChangeTo((ErgoAddress)p2PKAddress).build();
        return unsignedTransaction;
    }

    public static SignedTransaction spendBoxesTx(BlockchainContext blockchainContext, UnsignedTransactionBuilder unsignedTransactionBuilder, List<InputBox> list, ErgoProver ergoProver, Address address, long l, long l2) {
        OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(new ErgoTreeContract(address.getErgoAddress().script())).build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list).outputs(outBox).fee(l2).sendChangeTo((ErgoAddress)ergoProver.getP2PKAddress()).build();
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        return signedTransaction;
    }
}

