/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.Proxy;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ErgoClient;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.config.ErgoNodeConfig;
import org.ergoplatform.appkit.impl.BlockchainContextBuilderImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.restapi.client.ApiClient;

public class RestApiErgoClient
implements ErgoClient {
    private final String _nodeUrl;
    private final NetworkType _networkType;
    private final ApiClient _client;
    private final String _explorerUrl;
    private final ExplorerApiClient _explorer;
    public static final String defaultMainnetExplorerUrl = "https://api.ergoplatform.com";
    public static final String defaultTestnetExplorerUrl = "https://api-testnet.ergoplatform.com";

    RestApiErgoClient(String string, NetworkType networkType, String string2, String string3, @Nullable Proxy proxy) {
        this._nodeUrl = string;
        this._networkType = networkType;
        this._client = new ApiClient(this._nodeUrl, "ApiKeyAuth", string2);
        if (proxy != null) {
            this._client.createDefaultAdapter(proxy);
        }
        this._explorerUrl = string3;
        this._explorer = !Strings.isNullOrEmpty((String)this._explorerUrl) ? (proxy != null ? new ExplorerApiClient(this._explorerUrl, proxy) : new ExplorerApiClient(this._explorerUrl)) : null;
    }

    @Override
    public <T> T execute(Function<BlockchainContext, T> function) {
        BlockchainContext blockchainContext = new BlockchainContextBuilderImpl(this._client, this._explorer, this._networkType).build();
        T t = function.apply(blockchainContext);
        return t;
    }

    public static String getDefaultExplorerUrl(NetworkType networkType) {
        switch (networkType) {
            case MAINNET: {
                return defaultMainnetExplorerUrl;
            }
        }
        return defaultTestnetExplorerUrl;
    }

    public static ErgoClient createWithoutExplorer(String string, NetworkType networkType, String string2) {
        return new RestApiErgoClient(string, networkType, string2, null, null);
    }

    public static ErgoClient create(String string, NetworkType networkType, String string2, String string3) {
        return new RestApiErgoClient(string, networkType, string2, string3, null);
    }

    public static ErgoClient createWithProxy(String string, NetworkType networkType, String string2, String string3, @Nullable Proxy proxy) {
        return new RestApiErgoClient(string, networkType, string2, string3, proxy);
    }

    public static ErgoClient create(ErgoNodeConfig ergoNodeConfig, String string) {
        return RestApiErgoClient.create(ergoNodeConfig.getNodeApi().getApiUrl(), ergoNodeConfig.getNetworkType(), ergoNodeConfig.getNodeApi().getApiKey(), string);
    }

    public static ErgoClient createWithProxy(ErgoNodeConfig ergoNodeConfig, String string, @Nullable Proxy proxy) {
        return RestApiErgoClient.createWithProxy(ergoNodeConfig.getNodeApi().getApiUrl(), ergoNodeConfig.getNetworkType(), ergoNodeConfig.getNodeApi().getApiKey(), string, proxy);
    }

    ApiClient getNodeApiClient() {
        return this._client;
    }

    ExplorerApiClient getExplorerApiClient() {
        Preconditions.checkNotNull((Object)this._explorer, (Object)"Explorer URL is not specified when RestApiErgoClient.create() is called.");
        return this._explorer;
    }
}

