/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.io.File;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.wallet.secrets.JsonSecretStorage;
import org.ergoplatform.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Option;
import scala.util.Failure;
import scala.util.Try;
import sigmastate.basics.DLogProtocol;

public class SecretStorage {
    public static EncryptionSettings DEFAULT_SETTINGS = new EncryptionSettings("HmacSHA256", 128000, 256);
    private final JsonSecretStorage _jsonStorage;

    SecretStorage(JsonSecretStorage jsonSecretStorage) {
        this._jsonStorage = jsonSecretStorage;
    }

    public boolean isLocked() {
        return this._jsonStorage.isLocked();
    }

    public File getFile() {
        return this._jsonStorage.secretFile();
    }

    public ExtendedSecretKey getSecret() {
        Option option = this._jsonStorage.secret();
        if (option.isEmpty()) {
            return null;
        }
        return (ExtendedSecretKey)option.get();
    }

    public Address getAddressFor(NetworkType networkType) {
        DLogProtocol.ProveDlog proveDlog = ((ExtendedSecretKey)this._jsonStorage.secret().get()).publicImage();
        P2PKAddress p2PKAddress = JavaHelpers.createP2PKAddress(proveDlog, networkType.networkPrefix);
        return new Address((ErgoAddress)p2PKAddress);
    }

    public void unlock(SecretString secretString) {
        Try try_ = this._jsonStorage.unlock(secretString.toInterface4JSecretString());
        if (try_.isFailure()) {
            Throwable throwable = ((Failure)try_).exception();
            throw new RuntimeException("Cannot unlock secrete storage.", throwable);
        }
    }

    public void unlock(String string) {
        this.unlock(SecretString.create(string));
    }

    public static SecretStorage createFromMnemonicIn(String string, Mnemonic mnemonic, SecretString secretString) {
        SecretStorageSettings secretStorageSettings = new SecretStorageSettings(string, DEFAULT_SETTINGS);
        SecretString secretString2 = mnemonic.getPassword();
        JsonSecretStorage jsonSecretStorage = JsonSecretStorage.restore((org.ergoplatform.wallet.interface4j.SecretString)mnemonic.getPhrase().toInterface4JSecretString(), JavaHelpers.secretStringToOption(secretString2 != null ? secretString2.toInterface4JSecretString() : null), (org.ergoplatform.wallet.interface4j.SecretString)secretString.toInterface4JSecretString(), (SecretStorageSettings)secretStorageSettings);
        return new SecretStorage(jsonSecretStorage);
    }

    public static SecretStorage createFromMnemonicIn(String string, Mnemonic mnemonic, String string2) {
        return SecretStorage.createFromMnemonicIn(string, mnemonic, SecretString.create(string2));
    }

    public static SecretStorage loadFrom(String string) {
        File file = new File(string);
        return SecretStorage.loadFrom(file);
    }

    public static SecretStorage loadFrom(File file) {
        if (!file.exists()) {
            throw new RuntimeException("SecreteStorage file not found: " + file.getPath());
        }
        return new SecretStorage(new JsonSecretStorage(file, DEFAULT_SETTINGS));
    }
}

