/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ergoplatform.appkit.ErgoToken;

public class SelectTokensHelper {
    private final HashMap<String, Long> tokensLeft = new HashMap();

    public SelectTokensHelper(Iterable<ErgoToken> iterable) {
        for (ErgoToken ergoToken : iterable) {
            this.tokensLeft.put(ergoToken.getId().toString(), ergoToken.getValue());
        }
    }

    public boolean foundNewTokens(Iterable<ErgoToken> iterable) {
        boolean bl = false;
        for (ErgoToken ergoToken : iterable) {
            String string = ergoToken.getId().toString();
            if (!this.tokensLeft.containsKey(string)) continue;
            Long l = this.tokensLeft.get(string);
            if (l > 0L) {
                bl = true;
            }
            this.tokensLeft.put(string, l - ergoToken.getValue());
        }
        return bl;
    }

    public boolean areTokensCovered() {
        boolean bl = true;
        for (Long l : this.tokensLeft.values()) {
            if (l <= 0L) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public List<ErgoToken> getRemainingTokenList() {
        ArrayList<ErgoToken> arrayList = new ArrayList<ErgoToken>();
        for (Map.Entry<String, Long> entry : this.tokensLeft.entrySet()) {
            long l = entry.getValue();
            if (l <= 0L) continue;
            arrayList.add(new ErgoToken(entry.getKey(), l));
        }
        return arrayList;
    }
}

