/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.Input;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.CoveringBoxes;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoWallet;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.PreHeader;
import org.ergoplatform.appkit.PreHeaderBuilder;
import org.ergoplatform.appkit.SelectTokensHelper;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.ErgoNodeFacade;
import org.ergoplatform.appkit.impl.ErgoProverBuilderImpl;
import org.ergoplatform.appkit.impl.ErgoWalletImpl;
import org.ergoplatform.appkit.impl.ExplorerFacade;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.PreHeaderBuilderImpl;
import org.ergoplatform.appkit.impl.PreHeaderImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionBuilderImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.restapi.client.ApiClient;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionDataInput;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.NodeInfo;
import org.ergoplatform.restapi.client.WalletBox;
import retrofit2.Retrofit;
import scala.collection.IndexedSeq;
import special.sigma.Header;

public class BlockchainContextImpl
extends BlockchainContextBase {
    private final ApiClient _client;
    private final Retrofit _retrofit;
    final PreHeaderImpl _preHeader;
    private ExplorerApiClient _explorer;
    private Retrofit _retrofitExplorer;
    private final NodeInfo _nodeInfo;
    private final List<BlockHeader> _headers;
    private ErgoWalletImpl _wallet;

    public BlockchainContextImpl(ApiClient apiClient, Retrofit retrofit, ExplorerApiClient explorerApiClient, Retrofit retrofit2, NetworkType networkType, NodeInfo nodeInfo, List<BlockHeader> list) {
        super(networkType);
        this._client = apiClient;
        this._retrofit = retrofit;
        this._explorer = explorerApiClient;
        this._retrofitExplorer = retrofit2;
        this._nodeInfo = nodeInfo;
        this._headers = list;
        Header header = ScalaBridge.isoBlockHeader().to(this._headers.get(0));
        this._preHeader = new PreHeaderImpl(JavaHelpers.toPreHeader(header));
    }

    @Override
    public PreHeaderBuilder createPreHeader() {
        return new PreHeaderBuilderImpl(this);
    }

    @Override
    public SignedTransaction signedTxFromJson(String string) {
        Gson gson = this.getApiClient().getGson();
        ErgoTransaction ergoTransaction = (ErgoTransaction)gson.fromJson(string, ErgoTransaction.class);
        ErgoLikeTransaction ergoLikeTransaction = ScalaBridge.isoErgoTransaction().to(ergoTransaction);
        return new SignedTransactionImpl(this, ergoLikeTransaction, 0);
    }

    @Override
    public UnsignedTransactionBuilder newTxBuilder() {
        return new UnsignedTransactionBuilderImpl(this);
    }

    @Override
    public InputBox[] getBoxesById(String ... stringArray) throws ErgoClientException {
        ArrayList<InputBoxImpl> arrayList = new ArrayList<InputBoxImpl>();
        for (String string : stringArray) {
            ErgoTransactionOutput ergoTransactionOutput = ErgoNodeFacade.getBoxById(this._retrofit, string);
            if (ergoTransactionOutput == null) {
                throw new ErgoClientException("Cannot load UTXO box " + string, null);
            }
            arrayList.add(new InputBoxImpl((BlockchainContextBase)this, ergoTransactionOutput));
        }
        return arrayList.toArray(new InputBox[0]);
    }

    @Override
    public ErgoProverBuilder newProverBuilder() {
        return new ErgoProverBuilderImpl(this);
    }

    @Override
    public int getHeight() {
        return this._headers.get(0).getHeight();
    }

    Retrofit getRetrofit() {
        return this._retrofit;
    }

    @Override
    ApiClient getApiClient() {
        return this._client;
    }

    private List<InputBox> getInputBoxes(List<OutputInfo> list) {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(list.size());
        for (OutputInfo outputInfo : list) {
            String string = outputInfo.getBoxId();
            ErgoTransactionOutput ergoTransactionOutput = ErgoNodeFacade.getBoxById(this._retrofit, string);
            if (ergoTransactionOutput == null) continue;
            arrayList.add(new InputBoxImpl((BlockchainContextBase)this, ergoTransactionOutput));
        }
        return arrayList;
    }

    @Override
    public NodeInfo getNodeInfo() {
        return this._nodeInfo;
    }

    public PreHeader getPreHeader() {
        return this._preHeader;
    }

    public List<BlockHeader> getHeaders() {
        return this._headers;
    }

    @Override
    public String sendTransaction(SignedTransaction signedTransaction) {
        ErgoLikeTransaction ergoLikeTransaction = ((SignedTransactionImpl)signedTransaction).getTx();
        List<ErgoTransactionDataInput> list = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionDataInput()).from((IndexedSeq<DataInput>)ergoLikeTransaction.dataInputs());
        List<ErgoTransactionInput> list2 = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionInput()).from((IndexedSeq<Input>)ergoLikeTransaction.inputs());
        List<ErgoTransactionOutput> list3 = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionOutput()).from((IndexedSeq<ErgoBox>)ergoLikeTransaction.outputs());
        ErgoTransaction ergoTransaction = new ErgoTransaction().id(ergoLikeTransaction.id()).dataInputs(list).inputs(list2).outputs(list3);
        return ErgoNodeFacade.sendTransaction(this._retrofit, ergoTransaction);
    }

    @Override
    public ErgoWallet getWallet() {
        if (this._wallet == null) {
            List<WalletBox> list = ErgoNodeFacade.getWalletUnspentBoxes(this._retrofit, 0, 0);
            this._wallet = new ErgoWalletImpl(list);
            this._wallet.setContext(this);
        }
        return this._wallet;
    }

    @Override
    public List<InputBox> getUnspentBoxesFor(Address address, int n, int n2) {
        Preconditions.checkNotNull((Object)this._retrofitExplorer, (Object)"Explorer URL is not specified when RestApiErgoClient.create() is called.");
        List<OutputInfo> list = ExplorerFacade.transactionsBoxesByAddressUnspentIdGet(this._retrofitExplorer, address.toString(), n, n2);
        return this.getInputBoxes(list);
    }

    @Override
    public CoveringBoxes getCoveringBoxesFor(Address address, long l, List<ErgoToken> list) {
        SelectTokensHelper selectTokensHelper = new SelectTokensHelper(list);
        Preconditions.checkArgument((l > 0L || !selectTokensHelper.areTokensCovered() ? 1 : 0) != 0, (Object)"amountToSpend or tokens to spend should be > 0");
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = l;
        int n = 0;
        while (true) {
            List<InputBox> list2 = this.getUnspentBoxesFor(address, n, 20);
            for (InputBox inputBox : list2) {
                if (this.isAlreadyAdded(arrayList, inputBox)) continue;
                boolean bl = selectTokensHelper.foundNewTokens(inputBox.getTokens());
                if (bl || l2 > 0L) {
                    arrayList.add(inputBox);
                    l2 -= inputBox.getValue().longValue();
                }
                if (l2 > 0L || !selectTokensHelper.areTokensCovered()) continue;
                return new CoveringBoxes(l, arrayList);
            }
            if (list2.size() == 0) {
                assert (l2 > 0L || !selectTokensHelper.areTokensCovered());
                return new CoveringBoxes(l, arrayList);
            }
            n += 20;
        }
    }

    private boolean isAlreadyAdded(ArrayList<InputBox> arrayList, InputBox inputBox) {
        boolean bl = false;
        for (InputBox inputBox2 : arrayList) {
            if (!inputBox2.getId().equals(inputBox.getId())) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

