/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client;

import java.net.Proxy;
import java.text.DateFormat;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.ergoplatform.explorer.client.GsonCustomConverterFactory;
import org.ergoplatform.explorer.client.JSON;
import org.ergoplatform.explorer.client.auth.ApiKeyAuth;
import org.ergoplatform.explorer.client.auth.HttpBasicAuth;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ExplorerApiClient {
    private String _hostUrl;
    private Map<String, Interceptor> apiAuthorizations;
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;
    private Proxy proxy;

    public ExplorerApiClient(String string) {
        this._hostUrl = string;
        this.apiAuthorizations = new LinkedHashMap<String, Interceptor>();
        this.createDefaultAdapter();
    }

    public ExplorerApiClient(String string, Proxy proxy) {
        this._hostUrl = string;
        this.apiAuthorizations = new LinkedHashMap<String, Interceptor>();
        this.proxy = proxy;
        this.createDefaultAdapter();
    }

    public ExplorerApiClient(String string, String[] stringArray) {
        this(string);
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        if (n2 < n) {
            String string2 = stringArray2[n2];
            throw new RuntimeException("auth name \"" + string2 + "\" not found in available auth names");
        }
    }

    public ExplorerApiClient(String string, String string2) {
        this(string, new String[]{string2});
    }

    public ExplorerApiClient(String string, String string2, String string3) {
        this(string, string2);
        this.setApiKey(string3);
    }

    public ExplorerApiClient(String string, String string2, String string3, String string4) {
        this(string, string2);
        this.setCredentials(string3, string4);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        this.okBuilder = new OkHttpClient.Builder();
        if (this.proxy != null) {
            this.okBuilder.proxy(this.proxy);
        }
        if (!this._hostUrl.endsWith("/")) {
            this._hostUrl = this._hostUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this._hostUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> clazz) {
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(clazz);
    }

    public ExplorerApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ExplorerApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ExplorerApiClient setOffsetDateTimeFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setOffsetDateTimeFormat(dateTimeFormatter);
        return this;
    }

    public ExplorerApiClient setLocalDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setLocalDateFormat(dateTimeFormatter);
        return this;
    }

    public ExplorerApiClient setApiKey(String string) {
        for (Interceptor interceptor : this.apiAuthorizations.values()) {
            if (!(interceptor instanceof ApiKeyAuth)) continue;
            ApiKeyAuth apiKeyAuth = (ApiKeyAuth)interceptor;
            apiKeyAuth.setApiKey(string);
            return this;
        }
        return this;
    }

    public ExplorerApiClient setCredentials(String string, String string2) {
        for (Interceptor interceptor : this.apiAuthorizations.values()) {
            if (!(interceptor instanceof HttpBasicAuth)) continue;
            HttpBasicAuth httpBasicAuth = (HttpBasicAuth)interceptor;
            httpBasicAuth.setCredentials(string, string2);
            return this;
        }
        return this;
    }

    public ExplorerApiClient setAccessToken(String string) {
        return this;
    }

    public ExplorerApiClient addAuthorization(String string, Interceptor interceptor) {
        if (this.apiAuthorizations.containsKey(string)) {
            throw new RuntimeException("auth name \"" + string + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(string, interceptor);
        this.okBuilder.addInterceptor(interceptor);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ExplorerApiClient setApiAuthorizations(Map<String, Interceptor> map) {
        this.apiAuthorizations = map;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ExplorerApiClient setAdapterBuilder(Retrofit.Builder builder) {
        this.adapterBuilder = builder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder builder) {
        for (Interceptor interceptor : this.apiAuthorizations.values()) {
            builder.addInterceptor(interceptor);
        }
    }

    public void configureFromOkclient(OkHttpClient okHttpClient) {
        this.okBuilder = okHttpClient.newBuilder();
        this.addAuthsToOkBuilder(this.okBuilder);
    }
}

