/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.DataInputInfo1;
import org.ergoplatform.explorer.client.model.InputInfo1;
import org.ergoplatform.explorer.client.model.OutputInfo1;

public class TransactionInfo1 {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="headerId")
    private String headerId = null;
    @SerializedName(value="inclusionHeight")
    private Integer inclusionHeight = null;
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="index")
    private Integer index = null;
    @SerializedName(value="confirmationsCount")
    private Integer confirmationsCount = null;
    @SerializedName(value="inputs")
    private List<InputInfo1> inputs = null;
    @SerializedName(value="dataInputs")
    private List<DataInputInfo1> dataInputs = null;
    @SerializedName(value="outputs")
    private List<OutputInfo1> outputs = null;

    public TransactionInfo1 id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="Transaction ID")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public TransactionInfo1 headerId(String string) {
        this.headerId = string;
        return this;
    }

    @Schema(required=true, description="ID of the corresponding header")
    public String getHeaderId() {
        return this.headerId;
    }

    public void setHeaderId(String string) {
        this.headerId = string;
    }

    public TransactionInfo1 inclusionHeight(Integer n) {
        this.inclusionHeight = n;
        return this;
    }

    @Schema(required=true, description="Height of the block the transaction was included in")
    public Integer getInclusionHeight() {
        return this.inclusionHeight;
    }

    public void setInclusionHeight(Integer n) {
        this.inclusionHeight = n;
    }

    public TransactionInfo1 timestamp(Long l) {
        this.timestamp = l;
        return this;
    }

    @Schema(required=true, description="Timestamp the transaction got into the network")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long l) {
        this.timestamp = l;
    }

    public TransactionInfo1 index(Integer n) {
        this.index = n;
        return this;
    }

    @Schema(required=true, description="Index of a transaction inside a block")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public TransactionInfo1 confirmationsCount(Integer n) {
        this.confirmationsCount = n;
        return this;
    }

    @Schema(required=true, description="Number of transaction confirmations")
    public Integer getConfirmationsCount() {
        return this.confirmationsCount;
    }

    public void setConfirmationsCount(Integer n) {
        this.confirmationsCount = n;
    }

    public TransactionInfo1 inputs(List<InputInfo1> list) {
        this.inputs = list;
        return this;
    }

    public TransactionInfo1 addInputsItem(InputInfo1 inputInfo1) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<InputInfo1>();
        }
        this.inputs.add(inputInfo1);
        return this;
    }

    @Schema(description="")
    public List<InputInfo1> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputInfo1> list) {
        this.inputs = list;
    }

    public TransactionInfo1 dataInputs(List<DataInputInfo1> list) {
        this.dataInputs = list;
        return this;
    }

    public TransactionInfo1 addDataInputsItem(DataInputInfo1 dataInputInfo1) {
        if (this.dataInputs == null) {
            this.dataInputs = new ArrayList<DataInputInfo1>();
        }
        this.dataInputs.add(dataInputInfo1);
        return this;
    }

    @Schema(description="")
    public List<DataInputInfo1> getDataInputs() {
        return this.dataInputs;
    }

    public void setDataInputs(List<DataInputInfo1> list) {
        this.dataInputs = list;
    }

    public TransactionInfo1 outputs(List<OutputInfo1> list) {
        this.outputs = list;
        return this;
    }

    public TransactionInfo1 addOutputsItem(OutputInfo1 outputInfo1) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<OutputInfo1>();
        }
        this.outputs.add(outputInfo1);
        return this;
    }

    @Schema(description="")
    public List<OutputInfo1> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputInfo1> list) {
        this.outputs = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionInfo1 transactionInfo1 = (TransactionInfo1)object;
        return Objects.equals(this.id, transactionInfo1.id) && Objects.equals(this.headerId, transactionInfo1.headerId) && Objects.equals(this.inclusionHeight, transactionInfo1.inclusionHeight) && Objects.equals(this.timestamp, transactionInfo1.timestamp) && Objects.equals(this.index, transactionInfo1.index) && Objects.equals(this.confirmationsCount, transactionInfo1.confirmationsCount) && Objects.equals(this.inputs, transactionInfo1.inputs) && Objects.equals(this.dataInputs, transactionInfo1.dataInputs) && Objects.equals(this.outputs, transactionInfo1.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.headerId, this.inclusionHeight, this.timestamp, this.index, this.confirmationsCount, this.inputs, this.dataInputs, this.outputs);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TransactionInfo1 {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    headerId: ").append(this.toIndentedString(this.headerId)).append("\n");
        stringBuilder.append("    inclusionHeight: ").append(this.toIndentedString(this.inclusionHeight)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        stringBuilder.append("    confirmationsCount: ").append(this.toIndentedString(this.confirmationsCount)).append("\n");
        stringBuilder.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        stringBuilder.append("    dataInputs: ").append(this.toIndentedString(this.dataInputs)).append("\n");
        stringBuilder.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

