/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxSelectorsJavaHelpers;
import org.ergoplatform.appkit.CoveringBoxes;
import org.ergoplatform.appkit.Eip4Token;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.appkit.SelectTokensHelper;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;

public class BoxOperations {
    private final BlockchainContext ctx;
    private final List<Address> senders;
    private final ErgoProver senderProver;
    private long amountToSpend = 0L;
    private List<ErgoToken> tokensToSpend = Collections.emptyList();
    private long feeAmount = 1000000L;
    private IUnspentBoxesLoader inputBoxesLoader = new ExplorerApiUnspentLoader();
    private static final long CHANGE_BOX_NANOERG = 1000000L;

    private BoxOperations(BlockchainContext blockchainContext, List<Address> list, @Nullable ErgoProver ergoProver) {
        this.ctx = blockchainContext;
        this.senders = list;
        this.senderProver = ergoProver;
    }

    public static BoxOperations createForSender(Address address, BlockchainContext blockchainContext) {
        return BoxOperations.createForSenders(Collections.singletonList(address), blockchainContext);
    }

    public static BoxOperations createForSenders(List<Address> list, BlockchainContext blockchainContext) {
        return new BoxOperations(blockchainContext, list, null);
    }

    public static BoxOperations createForEip3Prover(ErgoProver ergoProver, BlockchainContext blockchainContext) {
        List<Address> list = ergoProver.getEip3Addresses();
        Preconditions.checkState((list.size() > 0 ? 1 : 0) != 0, (Object)"EIP-3 addresses are not derived in the prover (use ErgoProverBuilder.withEip3Secret)");
        return new BoxOperations(blockchainContext, list, ergoProver);
    }

    public static BoxOperations createForProver(ErgoProver ergoProver, BlockchainContext blockchainContext) {
        return new BoxOperations(blockchainContext, Collections.singletonList(ergoProver.getAddress()), ergoProver);
    }

    public BoxOperations withAmountToSpend(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Amount to send must be >= 0");
        }
        this.amountToSpend = l;
        return this;
    }

    public BoxOperations withTokensToSpend(@Nonnull List<ErgoToken> list) {
        this.tokensToSpend = list;
        return this;
    }

    public BoxOperations withFeeAmount(long l) {
        if (l < 1000000L) {
            throw new IllegalArgumentException("Amount to send must be >= 1000000");
        }
        this.feeAmount = l;
        return this;
    }

    public BoxOperations withInputBoxesLoader(@Nonnull IUnspentBoxesLoader iUnspentBoxesLoader) {
        this.inputBoxesLoader = iUnspentBoxesLoader;
        return this;
    }

    @Deprecated
    public static ErgoProver createProver(BlockchainContext blockchainContext, Mnemonic mnemonic) {
        ErgoProver ergoProver = blockchainContext.newProverBuilder().withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword()).build();
        return ergoProver;
    }

    @Deprecated
    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, SecretString secretString) {
        return BoxOperations.createProver(blockchainContext, string, secretString.toStringUnsecure());
    }

    @Deprecated
    public static ErgoProverBuilder createProver(BlockchainContext blockchainContext, String string, String string2) {
        SecretStorage secretStorage = SecretStorage.loadFrom(string);
        secretStorage.unlock(string2);
        ErgoProverBuilder ergoProverBuilder = blockchainContext.newProverBuilder().withSecretStorage(secretStorage);
        return ergoProverBuilder;
    }

    public String send(Address address) {
        ErgoContract ergoContract = address.toErgoContract();
        SignedTransaction signedTransaction = this.putToContractTx(ergoContract);
        this.ctx.sendTransaction(signedTransaction);
        return signedTransaction.toJson(true);
    }

    public List<InputBox> loadTop() {
        long l;
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = l = this.amountToSpend + this.feeAmount;
        boolean bl = false;
        SelectTokensHelper selectTokensHelper = new SelectTokensHelper(this.tokensToSpend);
        List<ErgoToken> list = this.tokensToSpend;
        this.inputBoxesLoader.prepare(this.ctx, this.senders, l, this.tokensToSpend);
        for (Address address : this.senders) {
            this.inputBoxesLoader.prepareForAddress(address);
            CoveringBoxes coveringBoxes = BoxOperations.getCoveringBoxesFor(l2, list, bl, n -> this.inputBoxesLoader.loadBoxesPage(this.ctx, address, (Integer)n));
            if (!bl && coveringBoxes.isChangeBoxNeeded()) {
                bl = true;
                l2 += 1000000L;
            }
            for (InputBox inputBox : coveringBoxes.getBoxes()) {
                arrayList.add(inputBox);
                selectTokensHelper.useTokens(inputBox.getTokens());
                if ((l2 -= inputBox.getValue()) > 0L || !selectTokensHelper.areTokensCovered()) continue;
                break;
            }
            if (l2 <= 0L && selectTokensHelper.areTokensCovered()) break;
            list = selectTokensHelper.getRemainingTokenList();
        }
        List<InputBox> list2 = BoxSelectorsJavaHelpers.selectBoxes(arrayList, l, this.tokensToSpend);
        return list2;
    }

    public SignedTransaction putToContractTx(ErgoContract ergoContract) {
        if (this.senderProver == null) {
            throw new IllegalStateException("Call this only when prover is set");
        }
        UnsignedTransaction unsignedTransaction = this.putToContractTxUnsigned(ergoContract);
        SignedTransaction signedTransaction = this.senderProver.sign(unsignedTransaction);
        return signedTransaction;
    }

    public UnsignedTransaction putToContractTxUnsigned(ErgoContract ergoContract) {
        return this.buildTxWithDefaultInputs(unsignedTransactionBuilder -> {
            OutBoxBuilder outBoxBuilder = unsignedTransactionBuilder.outBoxBuilder().value(this.amountToSpend).contract(ergoContract);
            if (!this.tokensToSpend.isEmpty()) {
                outBoxBuilder.tokens(this.tokensToSpend.toArray(new ErgoToken[0]));
            }
            OutBox outBox = outBoxBuilder.build();
            unsignedTransactionBuilder.outputs(outBox);
            return unsignedTransactionBuilder;
        });
    }

    public UnsignedTransaction mintTokenToContractTxUnsigned(ErgoContract ergoContract, Function<String, Eip4Token> function) {
        if (!this.tokensToSpend.isEmpty()) {
            throw new IllegalArgumentException("Mint token not possible with spending tokens");
        }
        return this.buildTxWithDefaultInputs(unsignedTransactionBuilder -> {
            OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(this.amountToSpend).contract(ergoContract).mintToken((Eip4Token)function.apply(unsignedTransactionBuilder.getInputBoxes().get(0).getId().toString())).build();
            unsignedTransactionBuilder.outputs(outBox);
            return unsignedTransactionBuilder;
        });
    }

    public UnsignedTransaction buildTxWithDefaultInputs(Function<UnsignedTransactionBuilder, UnsignedTransactionBuilder> function) {
        List<InputBox> list = this.loadTop();
        P2PKAddress p2PKAddress = this.senders.get(0).asP2PK();
        UnsignedTransactionBuilder unsignedTransactionBuilder = this.ctx.newTxBuilder();
        UnsignedTransactionBuilder unsignedTransactionBuilder2 = unsignedTransactionBuilder.boxesToSpend(list).fee(1000000L).sendChangeTo((ErgoAddress)p2PKAddress);
        return function.apply(unsignedTransactionBuilder2).build();
    }

    public static SignedTransaction spendBoxesTx(BlockchainContext blockchainContext, UnsignedTransactionBuilder unsignedTransactionBuilder, List<InputBox> list, ErgoProver ergoProver, Address address, long l, long l2) {
        OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(address.toErgoContract()).build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list).outputs(outBox).fee(l2).sendChangeTo((ErgoAddress)ergoProver.getP2PKAddress()).build();
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        return signedTransaction;
    }

    public static CoveringBoxes getCoveringBoxesFor(long l, List<ErgoToken> list, boolean bl, Function<Integer, List<InputBox>> function) {
        SelectTokensHelper selectTokensHelper = new SelectTokensHelper(list);
        Preconditions.checkArgument((l > 0L || !selectTokensHelper.areTokensCovered() ? 1 : 0) != 0, (Object)"amountToSpend or tokens to spend should be > 0");
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = l;
        int n = 0;
        while (true) {
            List<InputBox> list2 = function.apply(n);
            for (InputBox inputBox : list2) {
                if (BoxOperations.isAlreadyAdded(arrayList, inputBox)) continue;
                boolean bl2 = selectTokensHelper.areTokensNeeded(inputBox.getTokens());
                if (bl2 || l2 > 0L) {
                    arrayList.add(inputBox);
                    l2 -= inputBox.getValue();
                    selectTokensHelper.useTokens(inputBox.getTokens());
                    if (!bl && selectTokensHelper.isChangeBoxNeeded()) {
                        bl = true;
                        l2 += 1000000L;
                        l += 1000000L;
                    }
                }
                if (l2 > 0L || !selectTokensHelper.areTokensCovered()) continue;
                return new CoveringBoxes(l, arrayList, list, bl);
            }
            if (list2.size() == 0) {
                assert (l2 > 0L || !selectTokensHelper.areTokensCovered());
                return new CoveringBoxes(l, arrayList, list, bl);
            }
            ++n;
        }
    }

    private static boolean isAlreadyAdded(ArrayList<InputBox> arrayList, InputBox inputBox) {
        boolean bl = false;
        for (InputBox inputBox2 : arrayList) {
            if (!inputBox2.getId().equals(inputBox.getId())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static class ExplorerApiUnspentLoader
    implements IUnspentBoxesLoader {
        @Override
        public void prepare(@Nonnull BlockchainContext blockchainContext, List<Address> list, long l, @Nonnull List<ErgoToken> list2) {
        }

        @Override
        public void prepareForAddress(Address address) {
        }

        @Override
        @Nonnull
        public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext blockchainContext, @Nonnull Address address, @Nonnull Integer n) {
            return blockchainContext.getUnspentBoxesFor(address, n * 20, 20);
        }
    }

    public static abstract class ExplorerApiWithCheckerLoader
    extends ExplorerApiUnspentLoader {
        protected abstract boolean canUseBox(InputBox var1);

        @Override
        @Nonnull
        public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext blockchainContext, @Nonnull Address address, @Nonnull Integer n) {
            List<InputBox> list = super.loadBoxesPage(blockchainContext, address, n);
            ArrayList<InputBox> arrayList = new ArrayList<InputBox>(list.size());
            int n2 = 0;
            while (!list.isEmpty() && arrayList.isEmpty()) {
                for (InputBox inputBox : list) {
                    if (!this.canUseBox(inputBox)) continue;
                    arrayList.add(inputBox);
                }
                if (!arrayList.isEmpty()) continue;
                list = super.loadBoxesPage(blockchainContext, address, n + ++n2);
            }
            return arrayList;
        }
    }

    public static interface IUnspentBoxesLoader {
        public void prepare(@Nonnull BlockchainContext var1, List<Address> var2, long var3, @Nonnull List<ErgoToken> var5);

        public void prepareForAddress(Address var1);

        @Nonnull
        public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext var1, @Nonnull Address var2, @Nonnull Integer var3);
    }
}

