/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ergoplatform.appkit.BoxSelectorsJavaHelpers;
import org.ergoplatform.appkit.ErgoWallet;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.restapi.client.WalletBox;

public class ErgoWalletImpl
implements ErgoWallet {
    private final List<WalletBox> _unspentBoxesData;
    private BlockchainContextImpl _ctx;
    private List<InputBox> _unspentBoxes;

    public ErgoWalletImpl(List<WalletBox> list) {
        Preconditions.checkNotNull(list);
        this._unspentBoxesData = list;
    }

    void setContext(BlockchainContextImpl blockchainContextImpl) {
        Preconditions.checkState((this._ctx == null ? 1 : 0) != 0, (String)"Cannot reset context of wallet %s", (Object)this);
        this._ctx = blockchainContextImpl;
    }

    @Override
    public Optional<List<InputBox>> getUnspentBoxes(long l) {
        List<InputBox> list;
        if (this._unspentBoxes == null) {
            this._unspentBoxes = this._unspentBoxesData.stream().map(walletBox -> new InputBoxImpl((BlockchainContextBase)this._ctx, walletBox.getBox())).collect(Collectors.toList());
        }
        if ((list = BoxSelectorsJavaHelpers.selectBoxes(this._unspentBoxes, l, Collections.emptyList())) == null) {
            return Optional.empty();
        }
        return Optional.of(list);
    }
}

