/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.SigmaConstants;
import org.ergoplatform.appkit.Eip4Token;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.JavaHelpers$;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionBuilderImpl;
import scala.Byte;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sigmastate.Values;
import special.collection.Coll;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\r\u001b\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001a\u0001\n\u0013\u0001\u0005bB$\u0001\u0001\u0004%I\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0015B!\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%9\u0006\u00011A\u0001B\u0003&\u0011\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\r\u0015\u0004\u0001\u0015!\u0003[\u0011\u001d1\u0007A1A\u0005\n\u001dDa!\u001d\u0001!\u0002\u0013A\u0007bB=\u0001\u0001\u0004%IA\u001f\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000bAq!!\u0003\u0001A\u0003&1\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!a\u0013\u0001\t\u0003\niEA\tPkR\u0014u\u000e\u001f\"vS2$WM]%na2T!a\u0007\u000f\u0002\t%l\u0007\u000f\u001c\u0006\u0003;y\ta!\u00199qW&$(BA\u0010!\u00031)'oZ8qY\u0006$hm\u001c:n\u0015\u0005\t\u0013aA8sO\u000e\u00011c\u0001\u0001%YA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB(cU\u0016\u001cG\u000f\u0005\u0002.]5\tA$\u0003\u000209\tiq*\u001e;C_b\u0014U/\u001b7eKJ\fAa\u0018;y\u0005B\u0011!gM\u0007\u00025%\u0011AG\u0007\u0002\u001f+:\u001c\u0018n\u001a8fIR\u0013\u0018M\\:bGRLwN\u001c\"vS2$WM]%na2\fa\u0001P5oSRtDCA\u001c9!\t\u0011\u0004\u0001C\u00031\u0005\u0001\u0007\u0011'\u0001\u0003`GRDX#A\u001e\u0011\u0005Ib\u0014BA\u001f\u001b\u0005U\u0011En\\2lG\"\f\u0017N\\\"p]R,\u0007\u0010^%na2\fQaX2uq\u0002\naa\u0018<bYV,W#A!\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\t1{gnZ\u0001\u000b?Z\fG.^3`I\u0015\fHCA%M!\t\u0011%*\u0003\u0002L\u0007\n!QK\\5u\u0011\u001die!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003\u001dyf/\u00197vK\u0002\n\u0011bX2p]R\u0014\u0018m\u0019;\u0016\u0003E\u0003\"!\f*\n\u0005Mc\"\u0001D#sO>\u001cuN\u001c;sC\u000e$\u0018!D0d_:$(/Y2u?\u0012*\u0017\u000f\u0006\u0002J-\"9Q*CA\u0001\u0002\u0004\t\u0016AC0d_:$(/Y2uA\u00059q\f^8lK:\u001cX#\u0001.\u0011\u0007m\u0003'-D\u0001]\u0015\tif,A\u0004nkR\f'\r\\3\u000b\u0005}\u001b\u0015AC2pY2,7\r^5p]&\u0011\u0011\r\u0018\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002.G&\u0011A\r\b\u0002\n\u000bJ<w\u000eV8lK:\f\u0001b\u0018;pW\u0016t7\u000fI\u0001\u000b?J,w-[:uKJ\u001cX#\u00015\u0011\u0007m\u0003\u0017\u000e\r\u0002k_B\u0019Qf[7\n\u00051d\"!C#sO>4\u0016\r\\;f!\tqw\u000e\u0004\u0001\u0005\u0013At\u0011\u0011!A\u0001\u0006\u0003\u0011(aA0%c\u0005YqL]3hSN$XM]:!#\t\u0019h\u000f\u0005\u0002Ci&\u0011Qo\u0011\u0002\b\u001d>$\b.\u001b8h!\t\u0011u/\u0003\u0002y\u0007\n\u0019\u0011I\\=\u0002%}\u001b'/Z1uS>t\u0007*Z5hQR|\u0005\u000f^\u000b\u0002wB\u0019!\t @\n\u0005u\u001c%AB(qi&|g\u000e\u0005\u0002C\u007f&\u0019\u0011\u0011A\"\u0003\u0007%sG/\u0001\f`GJ,\u0017\r^5p]\"+\u0017n\u001a5u\u001fB$x\fJ3r)\rI\u0015q\u0001\u0005\b\u001bB\t\t\u00111\u0001|\u0003My6M]3bi&|g\u000eS3jO\"$x\n\u001d;!\u0003\u00151\u0018\r\\;f)\r9\u0014q\u0002\u0005\u0007\u0003\u0017\u0011\u0002\u0019A!\u0002\u0011\r|g\u000e\u001e:bGR$2aNA\u000b\u0011\u0019\t\tb\u0005a\u0001#\u00061Ao\\6f]N$2aNA\u000e\u0011\u001d\t9\u0002\u0006a\u0001\u0003;\u0001BAQA\u0010E&\u0019\u0011\u0011E\"\u0003\u0015q\u0012X\r]3bi\u0016$g(A\u0005nS:$Hk\\6f]R\u0019A&a\n\t\u000f\u0005%R\u00031\u0001\u0002,\u0005)Ao\\6f]B\u0019Q&!\f\n\u0007\u0005=BDA\u0005FSB$Dk\\6f]\u0006I!/Z4jgR,'o\u001d\u000b\u0004o\u0005U\u0002bBA\u0019-\u0001\u0007\u0011q\u0007\t\u0006\u0005\u0006}\u0011\u0011\b\u0019\u0005\u0003w\ty\u0004\u0005\u0003.W\u0006u\u0002c\u00018\u0002@\u0011Y\u0011\u0011IA\u001b\u0003\u0003\u0005\tQ!\u0001s\u0005\ryFEM\u0001\u000fGJ,\u0017\r^5p]\"+\u0017n\u001a5u)\ra\u0013q\t\u0005\u0007\u0003\u0013:\u0002\u0019\u0001@\u0002\r!,\u0017n\u001a5u\u0003\u0015\u0011W/\u001b7e)\t\ty\u0005E\u0002.\u0003#J1!a\u0015\u001d\u0005\u0019yU\u000f\u001e\"pq\u0002")
public class OutBoxBuilderImpl
implements OutBoxBuilder {
    private final UnsignedTransactionBuilderImpl _txB;
    private final BlockchainContextImpl _ctx;
    private long _value;
    private ErgoContract _contract;
    private final ArrayBuffer<ErgoToken> _tokens;
    private final ArrayBuffer<ErgoValue<?>> _registers;
    private Option<Object> _creationHeightOpt;

    private BlockchainContextImpl _ctx() {
        return this._ctx;
    }

    private long _value() {
        return this._value;
    }

    private void _value_$eq(long x$1) {
        this._value = x$1;
    }

    private ErgoContract _contract() {
        return this._contract;
    }

    private void _contract_$eq(ErgoContract x$1) {
        this._contract = x$1;
    }

    private ArrayBuffer<ErgoToken> _tokens() {
        return this._tokens;
    }

    private ArrayBuffer<ErgoValue<?>> _registers() {
        return this._registers;
    }

    private Option<Object> _creationHeightOpt() {
        return this._creationHeightOpt;
    }

    private void _creationHeightOpt_$eq(Option<Object> x$1) {
        this._creationHeightOpt = x$1;
    }

    @Override
    public OutBoxBuilderImpl value(long value) {
        this._value_$eq(value);
        return this;
    }

    @Override
    public OutBoxBuilderImpl contract(ErgoContract contract) {
        this._contract_$eq(contract);
        return this;
    }

    public OutBoxBuilderImpl tokens(Seq<ErgoToken> tokens) {
        Predef$.MODULE$.require(tokens.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "At least one token should be specified");
        int maxTokens = BoxesRunTime.unboxToInt((Object)SigmaConstants.MaxTokens$.MODULE$.value());
        Predef$.MODULE$.require(tokens.size() <= maxTokens, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(SigmaConstants.MaxTokens$.MODULE$.description()).append(": ").append(maxTokens).toString());
        this._tokens().$plus$plus$eq(tokens);
        return this;
    }

    @Override
    public OutBoxBuilder mintToken(Eip4Token token) {
        Object object;
        ErgoValue<Coll<Byte>> tokenNameVal = token.getMintingBoxR4();
        ErgoValue<Coll<Byte>> tokenDescVal = token.getMintingBoxR5();
        ErgoValue<Coll<Byte>> tokenNumOfDecVal = token.getMintingBoxR6();
        this._registers().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ErgoValue[]{tokenNameVal, tokenDescVal, tokenNumOfDecVal})));
        if (token.getMintingBoxR7() != null && token.getMintingBoxR8() != null) {
            this._registers().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ErgoValue[]{token.getMintingBoxR7(), token.getMintingBoxR8()})));
            object = token.getMintingBoxR9() != null ? this._registers().$plus$eq(token.getMintingBoxR9()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        this._tokens().$plus$eq((Object)token);
        return this;
    }

    public OutBoxBuilderImpl registers(Seq<ErgoValue<?>> registers) {
        Preconditions.checkArgument((boolean)registers.nonEmpty(), (Object)"At least one register should be specified");
        this._registers().$plus$plus$eq(registers);
        return this;
    }

    @Override
    public OutBoxBuilder creationHeight(int height) {
        this._creationHeightOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)height)));
        return this;
    }

    @Override
    public OutBox build() {
        Preconditions.checkState((this._contract() != null ? 1 : 0) != 0, (Object)"Contract is not defined");
        Values.ErgoTree tree = this._contract().getErgoTree();
        ErgoBoxCandidate ergoBoxCandidate = JavaHelpers$.MODULE$.createBoxCandidate(this._value(), tree, (Seq<ErgoToken>)this._tokens(), (Seq<ErgoValue<?>>)this._registers(), BoxesRunTime.unboxToInt((Object)this._creationHeightOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this._txB.getCtx().getHeight())));
        return new OutBoxImpl(this._ctx(), ergoBoxCandidate);
    }

    @Override
    public OutBoxBuilderImpl registers(ErgoValue<?>[] registers) {
        return this.registers((Seq<ErgoValue<?>>)Predef$.MODULE$.wrapRefArray((Object[])registers));
    }

    @Override
    public OutBoxBuilderImpl tokens(ErgoToken[] tokens) {
        return this.tokens((Seq<ErgoToken>)Predef$.MODULE$.wrapRefArray((Object[])tokens));
    }

    public OutBoxBuilderImpl(UnsignedTransactionBuilderImpl _txB) {
        this._txB = _txB;
        this._ctx = (BlockchainContextImpl)_txB.getCtx();
        this._value = 0L;
        this._tokens = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this._registers = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this._creationHeightOpt = None$.MODULE$;
    }
}

