/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class Parameters {
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="storageFeeFactor")
    private Integer storageFeeFactor = null;
    @SerializedName(value="minValuePerByte")
    private Integer minValuePerByte = null;
    @SerializedName(value="maxBlockSize")
    private Integer maxBlockSize = null;
    @SerializedName(value="maxBlockCost")
    private Integer maxBlockCost = null;
    @SerializedName(value="blockVersion")
    private Integer blockVersion = null;
    @SerializedName(value="tokenAccessCost")
    private Integer tokenAccessCost = null;
    @SerializedName(value="inputCost")
    private Integer inputCost = null;
    @SerializedName(value="dataInputCost")
    private Integer dataInputCost = null;
    @SerializedName(value="outputCost")
    private Integer outputCost = null;

    public Parameters height(Integer n) {
        this.height = n;
        return this;
    }

    @Schema(example="667", required=true, description="Height when current parameters were considered(not actual height). Can be '0' if state is empty")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer n) {
        this.height = n;
    }

    public Parameters storageFeeFactor(Integer n) {
        this.storageFeeFactor = n;
        return this;
    }

    @Schema(example="100000", required=true, description="Storage fee coefficient (per byte per storage period ~4 years)")
    public Integer getStorageFeeFactor() {
        return this.storageFeeFactor;
    }

    public void setStorageFeeFactor(Integer n) {
        this.storageFeeFactor = n;
    }

    public Parameters minValuePerByte(Integer n) {
        this.minValuePerByte = n;
        return this;
    }

    @Schema(example="360", required=true, description="Minimum value per byte of an output")
    public Integer getMinValuePerByte() {
        return this.minValuePerByte;
    }

    public void setMinValuePerByte(Integer n) {
        this.minValuePerByte = n;
    }

    public Parameters maxBlockSize(Integer n) {
        this.maxBlockSize = n;
        return this;
    }

    @Schema(example="1048576", required=true, description="Maximum block size (in bytes)")
    public Integer getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public void setMaxBlockSize(Integer n) {
        this.maxBlockSize = n;
    }

    public Parameters maxBlockCost(Integer n) {
        this.maxBlockCost = n;
        return this;
    }

    @Schema(example="104876", required=true, description="Maximum cumulative computational cost of input scripts in block transactions")
    public Integer getMaxBlockCost() {
        return this.maxBlockCost;
    }

    public void setMaxBlockCost(Integer n) {
        this.maxBlockCost = n;
    }

    public Parameters blockVersion(Integer n) {
        this.blockVersion = n;
        return this;
    }

    @Schema(required=true, description="")
    public Integer getBlockVersion() {
        return this.blockVersion;
    }

    public void setBlockVersion(Integer n) {
        this.blockVersion = n;
    }

    public Parameters tokenAccessCost(Integer n) {
        this.tokenAccessCost = n;
        return this;
    }

    @Schema(example="100", required=true, description="Validation cost of a single token")
    public Integer getTokenAccessCost() {
        return this.tokenAccessCost;
    }

    public void setTokenAccessCost(Integer n) {
        this.tokenAccessCost = n;
    }

    public Parameters inputCost(Integer n) {
        this.inputCost = n;
        return this;
    }

    @Schema(example="100", required=true, description="Validation cost per one transaction input")
    public Integer getInputCost() {
        return this.inputCost;
    }

    public void setInputCost(Integer n) {
        this.inputCost = n;
    }

    public Parameters dataInputCost(Integer n) {
        this.dataInputCost = n;
        return this;
    }

    @Schema(example="100", required=true, description="Validation cost per one data input")
    public Integer getDataInputCost() {
        return this.dataInputCost;
    }

    public void setDataInputCost(Integer n) {
        this.dataInputCost = n;
    }

    public Parameters outputCost(Integer n) {
        this.outputCost = n;
        return this;
    }

    @Schema(example="100", required=true, description="Validation cost per one transaction output")
    public Integer getOutputCost() {
        return this.outputCost;
    }

    public void setOutputCost(Integer n) {
        this.outputCost = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Parameters parameters = (Parameters)object;
        return Objects.equals(this.height, parameters.height) && Objects.equals(this.storageFeeFactor, parameters.storageFeeFactor) && Objects.equals(this.minValuePerByte, parameters.minValuePerByte) && Objects.equals(this.maxBlockSize, parameters.maxBlockSize) && Objects.equals(this.maxBlockCost, parameters.maxBlockCost) && Objects.equals(this.blockVersion, parameters.blockVersion) && Objects.equals(this.tokenAccessCost, parameters.tokenAccessCost) && Objects.equals(this.inputCost, parameters.inputCost) && Objects.equals(this.dataInputCost, parameters.dataInputCost) && Objects.equals(this.outputCost, parameters.outputCost);
    }

    public int hashCode() {
        return Objects.hash(this.height, this.storageFeeFactor, this.minValuePerByte, this.maxBlockSize, this.maxBlockCost, this.blockVersion, this.tokenAccessCost, this.inputCost, this.dataInputCost, this.outputCost);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Parameters {\n");
        stringBuilder.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        stringBuilder.append("    storageFeeFactor: ").append(this.toIndentedString(this.storageFeeFactor)).append("\n");
        stringBuilder.append("    minValuePerByte: ").append(this.toIndentedString(this.minValuePerByte)).append("\n");
        stringBuilder.append("    maxBlockSize: ").append(this.toIndentedString(this.maxBlockSize)).append("\n");
        stringBuilder.append("    maxBlockCost: ").append(this.toIndentedString(this.maxBlockCost)).append("\n");
        stringBuilder.append("    blockVersion: ").append(this.toIndentedString(this.blockVersion)).append("\n");
        stringBuilder.append("    tokenAccessCost: ").append(this.toIndentedString(this.tokenAccessCost)).append("\n");
        stringBuilder.append("    inputCost: ").append(this.toIndentedString(this.inputCost)).append("\n");
        stringBuilder.append("    dataInputCost: ").append(this.toIndentedString(this.dataInputCost)).append("\n");
        stringBuilder.append("    outputCost: ").append(this.toIndentedString(this.outputCost)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

