/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class Peer {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="lastSeen")
    private Integer lastSeen = null;
    @SerializedName(value="connectionType")
    private ConnectionTypeEnum connectionType = null;

    public Peer address(String string) {
        this.address = string;
        return this;
    }

    @Schema(example="127.0.0.1:5673", required=true, description="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public Peer name(String string) {
        this.name = string;
        return this;
    }

    @Schema(example="mynode", description="")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Peer lastSeen(Integer n) {
        this.lastSeen = n;
        return this;
    }

    @Schema(description="")
    public Integer getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Integer n) {
        this.lastSeen = n;
    }

    public Peer connectionType(ConnectionTypeEnum connectionTypeEnum) {
        this.connectionType = connectionTypeEnum;
        return this;
    }

    @Schema(description="")
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionTypeEnum connectionTypeEnum) {
        this.connectionType = connectionTypeEnum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Peer peer = (Peer)object;
        return Objects.equals(this.address, peer.address) && Objects.equals(this.name, peer.name) && Objects.equals(this.lastSeen, peer.lastSeen) && Objects.equals((Object)this.connectionType, (Object)peer.connectionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.name, this.lastSeen, this.connectionType});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Peer {\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        stringBuilder.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConnectionTypeEnum {
        INCOMING("Incoming"),
        OUTGOING("Outgoing");

        private String value;

        private ConnectionTypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConnectionTypeEnum fromValue(String string) {
            for (ConnectionTypeEnum connectionTypeEnum : ConnectionTypeEnum.values()) {
                if (!String.valueOf(connectionTypeEnum.value).equals(string)) continue;
                return connectionTypeEnum;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ConnectionTypeEnum> {
            public void write(JsonWriter jsonWriter, ConnectionTypeEnum connectionTypeEnum) throws IOException {
                jsonWriter.value(connectionTypeEnum.getValue());
            }

            public ConnectionTypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return ConnectionTypeEnum.fromValue(String.valueOf(string));
            }
        }
    }
}

