/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client.auth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiKeyAuth
implements Interceptor {
    private final String location;
    private final String paramName;
    private String apiKey;

    public ApiKeyAuth(String string, String string2) {
        this.location = string;
        this.paramName = string2;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String string) {
        this.apiKey = string;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if ("query".equals(this.location)) {
            URI uRI;
            String string = request.url().uri().getQuery();
            String string2 = this.paramName + "=" + this.apiKey;
            string = string == null ? string2 : string + "&" + string2;
            try {
                uRI = new URI(request.url().uri().getScheme(), request.url().uri().getAuthority(), request.url().uri().getPath(), string, request.url().uri().getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
            request = request.newBuilder().url(uRI.toURL()).build();
        } else if ("header".equals(this.location)) {
            request = request.newBuilder().addHeader(this.paramName, this.apiKey).build();
        }
        return chain.proceed(request);
    }
}

