/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.SelectTokensHelper;

public class CoveringBoxes {
    private final long _amountToSpend;
    private final List<InputBox> _boxes;
    private final List<ErgoToken> tokensToSpend;
    private final boolean changeBoxNeeded;

    public CoveringBoxes(long l, List<InputBox> list, List<ErgoToken> list2, boolean bl) {
        this._amountToSpend = l;
        this._boxes = list;
        this.tokensToSpend = list2;
        this.changeBoxNeeded = bl;
    }

    public long getCoveredAmount() {
        long l = 0L;
        for (InputBox inputBox : this._boxes) {
            l += inputBox.getValue();
        }
        return l;
    }

    public List<ErgoToken> getCoveredTokens() {
        HashMap<ErgoId, ErgoToken> hashMap = new HashMap<ErgoId, ErgoToken>();
        for (InputBox inputBox : this._boxes) {
            for (ErgoToken ergoToken : inputBox.getTokens()) {
                ErgoId ergoId = ergoToken.getId();
                if (!hashMap.containsKey(ergoId)) {
                    hashMap.put(ergoId, ergoToken);
                    continue;
                }
                ErgoToken ergoToken2 = (ErgoToken)hashMap.get(ergoId);
                hashMap.put(ergoId, new ErgoToken(ergoId, ergoToken.getValue() + ergoToken2.getValue()));
            }
        }
        return new ArrayList<ErgoToken>(hashMap.values());
    }

    public boolean isCovered() {
        return this.getCoveredAmount() >= this._amountToSpend && new SelectTokensHelper(this.tokensToSpend).useTokens(this.getCoveredTokens()).areTokensCovered();
    }

    public List<InputBox> getBoxes() {
        return this._boxes;
    }

    public boolean isChangeBoxNeeded() {
        return this.changeBoxNeeded;
    }
}

