/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import org.ergoplatform.appkit.BlockchainParameters;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.restapi.client.NodeInfo;

public class NodeInfoParameters
implements BlockchainParameters {
    private final NodeInfo nodeInfo;

    public NodeInfoParameters(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.fromValue(this.nodeInfo.getNetwork());
    }

    @Override
    public int getStorageFeeFactor() {
        return this.nodeInfo.getParameters().getStorageFeeFactor();
    }

    @Override
    public int getMinValuePerByte() {
        return this.nodeInfo.getParameters().getMinValuePerByte();
    }

    @Override
    public int getMaxBlockSize() {
        return this.nodeInfo.getParameters().getMaxBlockSize();
    }

    @Override
    public int getTokenAccessCost() {
        return this.nodeInfo.getParameters().getTokenAccessCost();
    }

    @Override
    public int getInputCost() {
        return this.nodeInfo.getParameters().getInputCost();
    }

    @Override
    public int getDataInputCost() {
        return this.nodeInfo.getParameters().getDataInputCost();
    }

    @Override
    public int getOutputCost() {
        return this.nodeInfo.getParameters().getOutputCost();
    }

    @Override
    public int getMaxBlockCost() {
        return this.nodeInfo.getParameters().getMaxBlockCost();
    }

    @Override
    public byte getBlockVersion() {
        return this.nodeInfo.getParameters().getBlockVersion().byteValue();
    }
}

