/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.math.BigDecimal;
import java.util.List;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.BlockTransactions;
import org.ergoplatform.restapi.client.FullBlock;
import org.ergoplatform.restapi.client.MerkleProof;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface BlocksApi {
    @GET(value="blocks/{headerId}/header")
    public Call<BlockHeader> getBlockHeaderById(@Path(value="headerId") String var1);

    @GET(value="blocks/{headerId}/transactions")
    public Call<BlockTransactions> getBlockTransactionsById(@Path(value="headerId") String var1);

    @GET(value="blocks/chainSlice")
    public Call<List<BlockHeader>> getChainSlice(@Query(value="fromHeight") Integer var1, @Query(value="toHeight") Integer var2);

    @GET(value="blocks/at/{blockHeight}")
    public Call<List<String>> getFullBlockAt(@Path(value="blockHeight") Integer var1);

    @GET(value="blocks/{headerId}")
    public Call<FullBlock> getFullBlockById(@Path(value="headerId") String var1);

    @GET(value="blocks")
    public Call<List<String>> getHeaderIds(@Query(value="limit") Integer var1, @Query(value="offset") Integer var2);

    @GET(value="blocks/lastHeaders/{count}")
    public Call<List<BlockHeader>> getLastHeaders(@Path(value="count") BigDecimal var1);

    @GET(value="blocks/modifier/{modifierId}")
    public Call<Void> getModifierById(@Path(value="modifierId") String var1);

    @GET(value="blocks/{headerId}/proofFor/{txId}")
    public Call<MerkleProof> getProofForTx(@Path(value="headerId") String var1, @Path(value="txId") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="blocks")
    public Call<Void> sendMinedBlock(@Body FullBlock var1);
}

