/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * Randomness and commitment for the first step of the Schnorr protocol
 */
@Schema(description = "Randomness and commitment for the first step of the Schnorr protocol")

public class DlogCommitment {
  @SerializedName("r")
  private String r = null;

  @SerializedName("a")
  private String a = null;

  public DlogCommitment r(String r) {
    this.r = r;
    return this;
  }

   /**
   * Hex-encoded big-endian 256-bits secret exponent
   * @return r
  **/
  @Schema(example = "433080ff80d0d52d7f8bfffff47f00807f44f680000949b800007f7f7ff1017f", required = true, description = "Hex-encoded big-endian 256-bits secret exponent")
  public String getR() {
    return r;
  }

  public void setR(String r) {
    this.r = r;
  }

  public DlogCommitment a(String a) {
    this.a = a;
    return this;
  }

   /**
   * Hex-encoded \&quot;g\&quot; generator for the Diffie-Hellman tuple (secp256k1 curve point)
   * @return a
  **/
  @Schema(example = "02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required = true, description = "Hex-encoded \"g\" generator for the Diffie-Hellman tuple (secp256k1 curve point)")
  public String getA() {
    return a;
  }

  public void setA(String a) {
    this.a = a;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DlogCommitment dlogCommitment = (DlogCommitment) o;
    return Objects.equals(this.r, dlogCommitment.r) &&
        Objects.equals(this.a, dlogCommitment.a);
  }

  @Override
  public int hashCode() {
    return Objects.hash(r, a);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DlogCommitment {\n");
    
    sb.append("    r: ").append(toIndentedString(r)).append("\n");
    sb.append("    a: ").append(toIndentedString(a)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
