/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.io.IOException;
import java.math.BigDecimal;
import org.ergoplatform.restapi.client.NipopowApi;
import org.ergoplatform.restapi.client.NipopowProof;
import org.ergoplatform.restapi.client.PeerFinder;
import org.ergoplatform.restapi.client.PopowHeader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NipopowApiTest
extends PeerFinder {
    private NipopowApi api;

    @Before
    public void setup() {
        this.api = (NipopowApi)this.findPeer(true).createService(NipopowApi.class);
    }

    @Test
    public void getPopowHeaderByHeightTest() throws IOException {
        Integer n = 500000;
        PopowHeader popowHeader = (PopowHeader)this.api.getPopowHeaderByHeight(n).execute().body();
        Assert.assertNotNull((Object)popowHeader);
        Assert.assertTrue((popowHeader.getInterlinks().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void getPopowHeaderByIdTest() throws IOException {
        String string = this.blockId;
        PopowHeader popowHeader = (PopowHeader)this.api.getPopowHeaderById(string).execute().body();
        Assert.assertNotNull((Object)popowHeader);
        Assert.assertTrue((popowHeader.getInterlinks().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void getPopowProofTest() throws IOException {
        BigDecimal bigDecimal = BigDecimal.valueOf(1L);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(1L);
        NipopowProof nipopowProof = (NipopowProof)this.api.getPopowProof(bigDecimal, bigDecimal2).execute().body();
        Assert.assertNotNull((Object)nipopowProof);
        Assert.assertTrue((nipopowProof.getPrefix().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void getPopowProofByHeaderIdTest() throws IOException {
        BigDecimal bigDecimal = BigDecimal.valueOf(1L);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(1L);
        String string = this.blockId;
        NipopowProof nipopowProof = (NipopowProof)this.api.getPopowProofByHeaderId(bigDecimal, bigDecimal2, string).execute().body();
        Assert.assertNotNull((Object)nipopowProof);
        Assert.assertTrue((nipopowProof.getPrefix().size() > 1 ? 1 : 0) != 0);
    }
}

