/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.ProofOfUpcomingTransactions;
/**
 * Block candidate related data for external miner to perform work
 */
@Schema(description = "Block candidate related data for external miner to perform work")

public class WorkMessage {
  @SerializedName("msg")
  private String msg = null;

  @SerializedName("b")
  private BigInteger b = null;

  @SerializedName("h")
  private Integer h = null;

  @SerializedName("pk")
  private String pk = null;

  @SerializedName("proof")
  private ProofOfUpcomingTransactions proof = null;

  public WorkMessage msg(String msg) {
    this.msg = msg;
    return this;
  }

   /**
   * Base16-encoded block header bytes without PoW solution
   * @return msg
  **/
  @Schema(example = "0350e25cee8562697d55275c96bb01b34228f9bd68fd9933f2a25ff195526864f5", required = true, description = "Base16-encoded block header bytes without PoW solution")
  public String getMsg() {
    return msg;
  }

  public void setMsg(String msg) {
    this.msg = msg;
  }

  public WorkMessage b(BigInteger b) {
    this.b = b;
    return this;
  }

   /**
   * Work target value
   * @return b
  **/
  @Schema(example = "987654321", required = true, description = "Work target value")
  public BigInteger getB() {
    return b;
  }

  public void setB(BigInteger b) {
    this.b = b;
  }

  public WorkMessage h(Integer h) {
    this.h = h;
    return this;
  }

   /**
   * Work target value
   * @return b
  **/
  @Schema(example = "987654321", required = true, description = "Work target value")
  public Integer getH() {
    return h;
  }

  public void setH(Integer h) {
    this.h = h;
  }

  public WorkMessage pk(String pk) {
    this.pk = pk;
    return this;
  }

   /**
   * Base16-encoded miner public key
   * @return pk
  **/
  @Schema(example = "0350e25cee8562697d55275c96bb01b34228f9bd68fd9933f2a25ff195526864f5", required = true, description = "Base16-encoded miner public key")
  public String getPk() {
    return pk;
  }

  public void setPk(String pk) {
    this.pk = pk;
  }

  public WorkMessage proof(ProofOfUpcomingTransactions proof) {
    this.proof = proof;
    return this;
  }

   /**
   * Get proof
   * @return proof
  **/
  @Schema(description = "")
  public ProofOfUpcomingTransactions getProof() {
    return proof;
  }

  public void setProof(ProofOfUpcomingTransactions proof) {
    this.proof = proof;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkMessage workMessage = (WorkMessage) o;
    return Objects.equals(this.msg, workMessage.msg) &&
        Objects.equals(this.b, workMessage.b) &&
        Objects.equals(this.pk, workMessage.pk) &&
        Objects.equals(this.proof, workMessage.proof);
  }

  @Override
  public int hashCode() {
    return Objects.hash(msg, b, pk, proof);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkMessage {\n");
    
    sb.append("    msg: ").append(toIndentedString(msg)).append("\n");
    sb.append("    b: ").append(toIndentedString(b)).append("\n");
    sb.append("    pk: ").append(toIndentedString(pk)).append("\n");
    sb.append("    proof: ").append(toIndentedString(proof)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
