/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.ergoplatform.ApiTestBase;
import org.ergoplatform.explorer.client.DefaultApi;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.explorer.client.model.Balance;
import org.ergoplatform.explorer.client.model.BlockSummary;
import org.ergoplatform.explorer.client.model.BoxQuery;
import org.ergoplatform.explorer.client.model.EpochParameters;
import org.ergoplatform.explorer.client.model.Items;
import org.ergoplatform.explorer.client.model.ItemsA;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.explorer.client.model.TokenInfo;
import org.ergoplatform.explorer.client.model.TotalBalance;
import org.ergoplatform.explorer.client.model.TransactionInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultApiTest
extends ApiTestBase {
    private DefaultApi api;

    @Before
    public void setup() {
        int n = 180;
        ExplorerApiClient explorerApiClient = new ExplorerApiClient("https://api.ergoplatform.com");
        explorerApiClient.configureFromOkClientBuilder(new OkHttpClient.Builder().connectTimeout((long)n, TimeUnit.SECONDS).readTimeout((long)n, TimeUnit.SECONDS).writeTimeout((long)n, TimeUnit.SECONDS));
        this.api = (DefaultApi)explorerApiClient.createService(DefaultApi.class);
    }

    @Test
    public void getApiV1AddressesP1BalanceConfirmedTest() throws IOException {
        Integer n = 1;
        Balance balance = (Balance)this.api.getApiV1AddressesP1BalanceConfirmed(this.address, n).execute().body();
        Assert.assertNotNull((Object)balance);
        Assert.assertTrue((balance.getNanoErgs() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1AddressesP1BalanceTotalTest() throws IOException {
        TotalBalance totalBalance = (TotalBalance)this.api.getApiV1AddressesP1BalanceTotal(this.address).execute().body();
        Assert.assertTrue((totalBalance.getConfirmed().getNanoErgs() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1AddressesP1TransactionsTest() throws IOException {
        Integer n;
        Integer n2 = 0;
        Items items = (Items)this.api.getApiV1AddressesP1Transactions(this.address, n2, n = Integer.valueOf(10), Boolean.valueOf(false)).execute().body();
        Assert.assertTrue((items.getItems().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((TransactionInfo)items.getItems().get(0)).getId());
        Items items2 = (Items)this.api.getApiV1AddressesP1Transactions(this.address, n2, n, Boolean.valueOf(true)).execute().body();
        Assert.assertEquals((long)items.getItems().size(), (long)items2.getItems().size());
        Assert.assertEquals((Object)((TransactionInfo)items.getItems().get(0)).getId(), (Object)((TransactionInfo)items2.getItems().get(0)).getId());
        Assert.assertTrue((((TransactionInfo)items.getItems().get(0)).getOutputs().size() > ((TransactionInfo)items2.getItems().get(0)).getOutputs().size() ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1MempoolTransactionsByaddressP1Test() throws IOException {
        Integer n = 0;
        Integer n2 = 10;
        Items items = (Items)this.api.getApiV1MempoolTransactionsByaddressP1(this.address, n, n2).execute().body();
        Assert.assertEquals((Object)items.getTotal(), (Object)items.getItems().size());
    }

    @Test
    public void getApiV1AssetsTest() throws IOException {
        Boolean bl;
        String string;
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1Assets(n2, n = Integer.valueOf(10), string = null, bl = null).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1AssetsSearchBytokenidTest() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1AssetsSearchBytokenid(this.tokenId, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BlocksTest() throws IOException {
        String string;
        String string2;
        Integer n;
        Integer n2 = 0;
        Items items = (Items)this.api.getApiV1Blocks(n2, n = Integer.valueOf(10), string2 = null, string = null).execute().body();
        Assert.assertTrue((items.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BlocksP1Test() throws IOException {
        BlockSummary blockSummary = (BlockSummary)this.api.getApiV1BlocksP1(this.blockId).execute().body();
        Assert.assertTrue((blockSummary.getBlock().getBlockTransactions().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesByaddressP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesByaddressP1(this.address, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesByergotreeP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesByergotreeP1(this.ergoTree, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesByergotreetemplatehashP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesByergotreetemplatehashP1(this.ergoTree, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesByergotreetemplatehashP1StreamTest() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
    }

    @Test
    public void getApiV1BoxesBytokenidP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesBytokenidP1(this.tokenId, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesP1Test() throws IOException {
        OutputInfo outputInfo = (OutputInfo)this.api.getApiV1BoxesP1(this.boxId).execute().body();
        Assert.assertEquals((Object)outputInfo.getBoxId(), (Object)this.boxId);
    }

    @Test
    public void getApiV1BoxesUnspentByaddressP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesUnspentByaddressP1(this.address, n2, n = Integer.valueOf(10), "asc").execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesUnspentByergotreeP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesUnspentByergotreeP1(this.ergoTree, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesUnspentByergotreetemplatehashP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesUnspentByergotreetemplatehashP1(this.ergoTree, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesUnspentByergotreetemplatehashP1StreamTest() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
    }

    @Test
    public void getApiV1BoxesUnspentBylastepochsStreamTest() {
        Object var1_1 = null;
    }

    @Test
    public void getApiV1BoxesUnspentBytokenidP1Test() throws IOException {
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1BoxesUnspentBytokenidP1(this.tokenId, n2, n = Integer.valueOf(10)).execute().body();
        Assert.assertTrue((itemsA.getItems().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1BoxesUnspentStreamTest() {
        Object var1_1 = null;
        Object var2_2 = null;
    }

    @Test
    public void getApiV1EpochsParamsTest() throws IOException {
        EpochParameters epochParameters = (EpochParameters)this.api.getApiV1EpochsParams().execute().body();
        Assert.assertTrue((epochParameters.getMaxBlockCost() > 1000000 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1TokensTest() throws IOException {
        Boolean bl;
        String string;
        Integer n;
        Integer n2 = 0;
        ItemsA itemsA = (ItemsA)this.api.getApiV1Tokens(n2, n = Integer.valueOf(10), string = null, bl = null).execute().body();
        Assert.assertTrue((itemsA.getItems().size() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void getApiV1TokensP1Test() throws IOException {
        TokenInfo tokenInfo = (TokenInfo)this.api.getApiV1TokensP1(this.tokenId).execute().body();
        Assert.assertEquals((Object)tokenInfo.getId(), (Object)this.tokenId);
    }

    @Test
    public void getApiV1TokensSearchTest() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
    }

    @Test
    public void getApiV1TransactionsByinputsscripttemplatehashP1Test() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
    }

    @Test
    public void getApiV1TransactionsP1Test() throws IOException {
        TransactionInfo transactionInfo = (TransactionInfo)this.api.getApiV1TransactionsP1(this.txId).execute().body();
        Assert.assertTrue((transactionInfo.getOutputs().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void postApiV1BoxesSearchTest() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("R4", "{\"serializedValue\": \"0702472963123ce32c057907c7a7268bc09f45d9ca57819d3327b9e7497d7b1cc347\"}");
        BoxQuery boxQuery = new BoxQuery().registers(hashMap);
        Integer n = 0;
        Integer n2 = 10;
    }
}

