/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.io.IOException;
import org.ergoplatform.restapi.client.AddressValidity;
import org.ergoplatform.restapi.client.PeerFinder;
import org.ergoplatform.restapi.client.UtilsApi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UtilsApiTest
extends PeerFinder {
    private UtilsApi api;

    @Before
    public void setup() {
        this.api = (UtilsApi)this.findPeer(true).createService(UtilsApi.class);
    }

    @Test
    public void addressToRawTest() throws IOException {
        String string = (String)this.api.addressToRaw(this.address).execute().body();
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"{\n  \"raw\" : \"036ba5cfbc03ea2471fdf02737f64dbcd58c34461a7ec1e586dcd713dacbf89a12\"\n}", (Object)string);
    }

    @Test
    public void checkAddressValidityTest() throws IOException {
        AddressValidity addressValidity = (AddressValidity)this.api.checkAddressValidity(this.address).execute().body();
        Assert.assertNotNull((Object)addressValidity);
        Assert.assertEquals((Object)this.address, (Object)addressValidity.getAddress());
        Assert.assertTrue((boolean)addressValidity.isIsValid());
    }

    @Test
    public void ergoTreeToAddressTest() throws IOException {
        String string = (String)this.api.ergoTreeToAddress(this.ergoTree).execute().body();
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((boolean)string.contains(this.address));
    }

    @Test
    public void getRandomSeedTest() throws IOException {
        String string = (String)this.api.getRandomSeed().execute().body();
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((string.length() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void getRandomSeedWithLengthTest() throws IOException {
        String string = "10";
        String string2 = (String)this.api.getRandomSeedWithLength(string).execute().body();
        Assert.assertNotNull((Object)string2);
        Assert.assertTrue((string2.length() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void hashBlake2bTest() throws IOException {
        String string = "\"hello\"";
        String string2 = (String)this.api.hashBlake2b(string).execute().body();
        Assert.assertEquals((Object)"\"324dcf027dd4a30a932c441f365a25e86b173defa4b8e58948253471b81b72cf\"", (Object)string2);
    }

    @Test
    public void rawToAddressTest() throws IOException {
        String string = "036ba5cfbc03ea2471fdf02737f64dbcd58c34461a7ec1e586dcd713dacbf89a12";
        String string2 = (String)this.api.rawToAddress(string).execute().body();
        Assert.assertEquals((Object)"{\n  \"address\" : \"9hHDQb26AjnJUXxcqriqY1mnhpLuUeC81C4pggtK7tupr92Ea1K\"\n}", (Object)string2);
    }
}

