/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.io.IOException;
import java.util.List;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.PeerFinder;
import org.ergoplatform.restapi.client.SerializedBox;
import org.ergoplatform.restapi.client.UtxoApi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UtxoApiTest
extends PeerFinder {
    private UtxoApi api;

    @Before
    public void setup() {
        this.api = (UtxoApi)this.findPeer(true).createService(UtxoApi.class);
    }

    @Test
    public void genesisBoxesTest() throws IOException {
        List list = (List)this.api.genesisBoxes().execute().body();
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getBoxByIdTest() throws IOException {
        ErgoTransactionOutput ergoTransactionOutput = (ErgoTransactionOutput)this.api.getBoxById(this.boxId).execute().body();
        Assert.assertNotNull((Object)ergoTransactionOutput);
        Assert.assertEquals((Object)this.boxId, (Object)ergoTransactionOutput.getBoxId());
        Assert.assertEquals((Object)this.ergoTree, (Object)ergoTransactionOutput.getErgoTree());
    }

    @Test
    public void getBoxByIdBinaryTest() throws IOException {
        SerializedBox serializedBox = (SerializedBox)this.api.getBoxByIdBinary(this.boxId).execute().body();
        Assert.assertNotNull((Object)serializedBox);
        Assert.assertTrue((serializedBox.getBytes().length() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void getBoxWithPoolByIdTest() throws IOException {
        ErgoTransactionOutput ergoTransactionOutput = (ErgoTransactionOutput)this.api.getBoxWithPoolById(this.boxId).execute().body();
        Assert.assertNotNull((Object)ergoTransactionOutput);
        Assert.assertEquals((Object)this.ergoTree, (Object)ergoTransactionOutput.getErgoTree());
    }

    @Test
    public void getBoxWithPoolByIdBinaryTest() throws IOException {
        SerializedBox serializedBox = (SerializedBox)this.api.getBoxWithPoolByIdBinary(this.boxId).execute().body();
        Assert.assertNotNull((Object)serializedBox);
        Assert.assertTrue((serializedBox.getBytes().length() > 10 ? 1 : 0) != 0);
    }
}

