/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.Collections;
import java.util.List;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.JavaHelpers$;
import org.ergoplatform.appkit.MnemonicValidationException;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.wallet.mnemonic.WordList;
import scala.Option;
import scala.util.Try;
import scorex.crypto.hash.Sha256;
import scorex.utils.Random;

public class Mnemonic {
    public static final String LANGUAGE_ID_ENGLISH = "english";
    private final char[] _phrase;
    private final char[] _password;
    public static int DEFAULT_STRENGTH = 160;

    Mnemonic(char[] cArray, char[] cArray2) {
        this._phrase = cArray;
        this._password = cArray2;
    }

    public static byte[] getEntropy(int n) {
        return Random.randomBytes((int)(n / 8));
    }

    public static String generate(String string, int n, byte[] byArray) {
        org.ergoplatform.wallet.mnemonic.Mnemonic mnemonic = new org.ergoplatform.wallet.mnemonic.Mnemonic(string, n);
        Try try_ = mnemonic.toMnemonic(byArray);
        if (try_.isFailure()) {
            throw new RuntimeException(String.format("Cannot create mnemonic for languageId: %s, strength: %d", string, n));
        }
        return ((org.ergoplatform.wallet.interface4j.SecretString)try_.get()).toStringUnsecure();
    }

    public static String generateEnglishMnemonic() {
        byte[] byArray = Mnemonic.getEntropy(DEFAULT_STRENGTH);
        return Mnemonic.generate(LANGUAGE_ID_ENGLISH, DEFAULT_STRENGTH, byArray);
    }

    public static Mnemonic create(char[] cArray, char[] cArray2) {
        return new Mnemonic(cArray, cArray2);
    }

    public static Mnemonic create(SecretString secretString, SecretString secretString2) {
        return new Mnemonic(secretString.getData(), secretString2.getData());
    }

    public SecretString getPhrase() {
        return SecretString.create(this._phrase);
    }

    public SecretString getPassword() {
        return SecretString.create(this._password);
    }

    public byte[] toSeed() {
        Option<String> option = Iso.arrayCharToOptionString().to(this.getPassword());
        return JavaHelpers.mnemonicToSeed(String.valueOf(this._phrase), option);
    }

    public static void checkEnglishMnemonic(List<String> list) throws MnemonicValidationException {
        Mnemonic.toEntropy(LANGUAGE_ID_ENGLISH, list);
    }

    public static byte[] toEntropy(String string, List<String> list) throws MnemonicValidationException {
        int n;
        if (list.size() % 3 > 0) {
            throw new MnemonicValidationException.MnemonicWrongListSizeException();
        }
        if (list.size() == 0) {
            throw new MnemonicValidationException.MnemonicEmptyException();
        }
        int n2 = list.size() * 11;
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        List list2 = JavaHelpers$.MODULE$.toJavaList(((WordList)WordList.load((String)string).get()).words().toList());
        for (String string2 : list) {
            int n4 = Collections.binarySearch(list2, string2);
            if (n4 < 0) {
                throw new MnemonicValidationException.MnemonicWordException(string2);
            }
            for (n = 0; n < 11; ++n) {
                blArray[n3 * 11 + n] = (n4 & 1 << 10 - n) != 0;
            }
            ++n3;
        }
        int n5 = n2 / 33;
        int n6 = n2 - n5;
        byte[] byArray = new byte[n6 / 8];
        for (n = 0; n < byArray.length; ++n) {
            for (int i = 0; i < 8; ++i) {
                if (!blArray[n * 8 + i]) continue;
                int n7 = n;
                byArray[n7] = (byte)(byArray[n7] | 1 << 7 - i);
            }
        }
        byte[] byArray2 = Sha256.hash((byte[])byArray);
        boolean[] blArray2 = Mnemonic.bytesToBits(byArray2);
        for (int i = 0; i < n5; ++i) {
            if (blArray[n6 + i] == blArray2[i]) continue;
            throw new MnemonicValidationException.MnemonicChecksumException();
        }
        return byArray;
    }

    private static boolean[] bytesToBits(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length * 8];
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                blArray[i * 8 + j] = (byArray[i] & 1 << 7 - j) != 0;
            }
        }
        return blArray;
    }
}

