/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.ErgoLikeTransactionSerializer$;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BlockchainParameters;
import org.ergoplatform.appkit.Constants;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.ReducedErgoLikeTransaction;
import org.ergoplatform.appkit.ReducedErgoLikeTransactionSerializer$;
import org.ergoplatform.appkit.ReducedTransaction;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.impl.ErgoScriptContract;
import org.ergoplatform.appkit.impl.ErgoTreeContract;
import org.ergoplatform.appkit.impl.ReducedTransactionImpl;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import sigmastate.Values;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.utils.SigmaByteReader;

public abstract class BlockchainContextBase
implements BlockchainContext {
    protected final NetworkType _networkType;

    public BlockchainContextBase(NetworkType networkType) {
        this._networkType = networkType;
    }

    @Override
    public ErgoContract newContract(Values.ErgoTree ergoTree) {
        return new ErgoTreeContract(ergoTree, this._networkType);
    }

    @Override
    public ErgoContract compileContract(Constants constants, String string) {
        return ErgoScriptContract.create(constants, string, this._networkType);
    }

    @Override
    public NetworkType getNetworkType() {
        return this._networkType;
    }

    public abstract BlockchainParameters getParameters();

    @Override
    public ReducedTransaction parseReducedTransaction(byte[] byArray) {
        SigmaByteReader sigmaByteReader = SigmaSerializer$.MODULE$.startReader(byArray, 0);
        ReducedErgoLikeTransaction reducedErgoLikeTransaction = ReducedErgoLikeTransactionSerializer$.MODULE$.parse(sigmaByteReader, this.getParameters().getBlockVersion());
        return new ReducedTransactionImpl(this, reducedErgoLikeTransaction);
    }

    @Override
    public SignedTransaction parseSignedTransaction(byte[] byArray) {
        SigmaByteReader sigmaByteReader = SigmaSerializer$.MODULE$.startReader(byArray, 0);
        ErgoLikeTransaction ergoLikeTransaction = ErgoLikeTransactionSerializer$.MODULE$.parse(sigmaByteReader);
        int n = (int)sigmaByteReader.getUInt();
        return new SignedTransactionImpl(this, ergoLikeTransaction, n);
    }
}

