/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.InputHints;

@Schema(description="prover hints extracted from a transaction")
public class TransactionHintsBag {
    @SerializedName(value="secretHints")
    private List<InputHints> secretHints = null;
    @SerializedName(value="publicHints")
    private List<InputHints> publicHints = null;

    public TransactionHintsBag secretHints(List<InputHints> list) {
        this.secretHints = list;
        return this;
    }

    public TransactionHintsBag addSecretHintsItem(InputHints inputHints) {
        if (this.secretHints == null) {
            this.secretHints = new ArrayList<InputHints>();
        }
        this.secretHints.add(inputHints);
        return this;
    }

    @Schema(description="Hints which contain secrets, do not share them!")
    public List<InputHints> getSecretHints() {
        return this.secretHints;
    }

    public void setSecretHints(List<InputHints> list) {
        this.secretHints = list;
    }

    public TransactionHintsBag publicHints(List<InputHints> list) {
        this.publicHints = list;
        return this;
    }

    public TransactionHintsBag addPublicHintsItem(InputHints inputHints) {
        if (this.publicHints == null) {
            this.publicHints = new ArrayList<InputHints>();
        }
        this.publicHints.add(inputHints);
        return this;
    }

    @Schema(description="Hints which contain public data only, share them freely!")
    public List<InputHints> getPublicHints() {
        return this.publicHints;
    }

    public void setPublicHints(List<InputHints> list) {
        this.publicHints = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionHintsBag transactionHintsBag = (TransactionHintsBag)object;
        return Objects.equals(this.secretHints, transactionHintsBag.secretHints) && Objects.equals(this.publicHints, transactionHintsBag.publicHints);
    }

    public int hashCode() {
        return Objects.hash(this.secretHints, this.publicHints);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TransactionHintsBag {\n");
        stringBuilder.append("    secretHints: ").append(this.toIndentedString(this.secretHints)).append("\n");
        stringBuilder.append("    publicHints: ").append(this.toIndentedString(this.publicHints)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

