/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.Transactions;
/**
 * Can be null if node is not mining or candidate block is not ready
 */
@Schema(description = "Can be null if node is not mining or candidate block is not ready")

public class CandidateBlock {
  @SerializedName("version")
  private Integer version = null;

  @SerializedName("extensionHash")
  private String extensionHash = null;

  @SerializedName("timestamp")
  private Integer timestamp = null;

  @SerializedName("stateRoot")
  private String stateRoot = null;

  @SerializedName("nBits")
  private Long nBits = null;

  @SerializedName("adProofBytes")
  private String adProofBytes = null;

  @SerializedName("parentId")
  private String parentId = null;

  @SerializedName("transactionsNumber")
  private Integer transactionsNumber = null;

  @SerializedName("transactions")
  private Transactions transactions = null;

  @SerializedName("votes")
  private String votes = null;

  public CandidateBlock version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(example = "2", description = "")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public CandidateBlock extensionHash(String extensionHash) {
    this.extensionHash = extensionHash;
    return this;
  }

   /**
   * Get extensionHash
   * @return extensionHash
  **/
  @Schema(required = true, description = "")
  public String getExtensionHash() {
    return extensionHash;
  }

  public void setExtensionHash(String extensionHash) {
    this.extensionHash = extensionHash;
  }

  public CandidateBlock timestamp(Integer timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @Schema(description = "")
  public Integer getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(Integer timestamp) {
    this.timestamp = timestamp;
  }

  public CandidateBlock stateRoot(String stateRoot) {
    this.stateRoot = stateRoot;
    return this;
  }

   /**
   * Get stateRoot
   * @return stateRoot
  **/
  @Schema(description = "")
  public String getStateRoot() {
    return stateRoot;
  }

  public void setStateRoot(String stateRoot) {
    this.stateRoot = stateRoot;
  }

  public CandidateBlock nBits(Long nBits) {
    this.nBits = nBits;
    return this;
  }

   /**
   * Get nBits
   * minimum: 0
   * @return nBits
  **/
  @Schema(example = "19857408", description = "")
  public Long getNBits() {
    return nBits;
  }

  public void setNBits(Long nBits) {
    this.nBits = nBits;
  }

  public CandidateBlock adProofBytes(String adProofBytes) {
    this.adProofBytes = adProofBytes;
    return this;
  }

   /**
   * Get adProofBytes
   * @return adProofBytes
  **/
  @Schema(description = "")
  public String getAdProofBytes() {
    return adProofBytes;
  }

  public void setAdProofBytes(String adProofBytes) {
    this.adProofBytes = adProofBytes;
  }

  public CandidateBlock parentId(String parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * Get parentId
   * @return parentId
  **/
  @Schema(required = true, description = "")
  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  public CandidateBlock transactionsNumber(Integer transactionsNumber) {
    this.transactionsNumber = transactionsNumber;
    return this;
  }

   /**
   * Get transactionsNumber
   * @return transactionsNumber
  **/
  @Schema(example = "2", description = "")
  public Integer getTransactionsNumber() {
    return transactionsNumber;
  }

  public void setTransactionsNumber(Integer transactionsNumber) {
    this.transactionsNumber = transactionsNumber;
  }

  public CandidateBlock transactions(Transactions transactions) {
    this.transactions = transactions;
    return this;
  }

   /**
   * Get transactions
   * @return transactions
  **/
  @Schema(description = "")
  public Transactions getTransactions() {
    return transactions;
  }

  public void setTransactions(Transactions transactions) {
    this.transactions = transactions;
  }

  public CandidateBlock votes(String votes) {
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @Schema(description = "")
  public String getVotes() {
    return votes;
  }

  public void setVotes(String votes) {
    this.votes = votes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CandidateBlock candidateBlock = (CandidateBlock) o;
    return Objects.equals(this.version, candidateBlock.version) &&
        Objects.equals(this.extensionHash, candidateBlock.extensionHash) &&
        Objects.equals(this.timestamp, candidateBlock.timestamp) &&
        Objects.equals(this.stateRoot, candidateBlock.stateRoot) &&
        Objects.equals(this.nBits, candidateBlock.nBits) &&
        Objects.equals(this.adProofBytes, candidateBlock.adProofBytes) &&
        Objects.equals(this.parentId, candidateBlock.parentId) &&
        Objects.equals(this.transactionsNumber, candidateBlock.transactionsNumber) &&
        Objects.equals(this.transactions, candidateBlock.transactions) &&
        Objects.equals(this.votes, candidateBlock.votes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, extensionHash, timestamp, stateRoot, nBits, adProofBytes, parentId, transactionsNumber, transactions, votes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CandidateBlock {\n");
    
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    extensionHash: ").append(toIndentedString(extensionHash)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    stateRoot: ").append(toIndentedString(stateRoot)).append("\n");
    sb.append("    nBits: ").append(toIndentedString(nBits)).append("\n");
    sb.append("    adProofBytes: ").append(toIndentedString(adProofBytes)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    transactionsNumber: ").append(toIndentedString(transactionsNumber)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
