/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.SigmaBoolean;
/**
 * basic trait for prover commitments
 */
@Schema(description = "basic trait for prover commitments")

public class Commitment {
  /**
   * Gets or Sets hint
   */
  @JsonAdapter(HintEnum.Adapter.class)
  public enum HintEnum {
    CMTWITHSECRET("cmtWithSecret"),
    CMTREAL("cmtReal"),
    CMTSIMULATED("cmtSimulated");

    private String value;

    HintEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static HintEnum fromValue(String text) {
      for (HintEnum b : HintEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<HintEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final HintEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public HintEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return HintEnum.fromValue(String.valueOf(value));
      }
    }
  }  @SerializedName("hint")
  private HintEnum hint = null;

  @SerializedName("pubkey")
  private SigmaBoolean pubkey = null;

  @SerializedName("position")
  private String position = null;

  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    DLOG("dlog"),
    DHT("dht");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("a")
  private String a = null;

  @SerializedName("b")
  private String b = null;

  public Commitment hint(HintEnum hint) {
    this.hint = hint;
    return this;
  }

   /**
   * Get hint
   * @return hint
  **/
  @Schema(required = true, description = "")
  public HintEnum getHint() {
    return hint;
  }

  public void setHint(HintEnum hint) {
    this.hint = hint;
  }

  public Commitment pubkey(SigmaBoolean pubkey) {
    this.pubkey = pubkey;
    return this;
  }

   /**
   * Get pubkey
   * @return pubkey
  **/
  @Schema(required = true, description = "")
  public SigmaBoolean getPubkey() {
    return pubkey;
  }

  public void setPubkey(SigmaBoolean pubkey) {
    this.pubkey = pubkey;
  }

  public Commitment position(String position) {
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @Schema(required = true, description = "")
  public String getPosition() {
    return position;
  }

  public void setPosition(String position) {
    this.position = position;
  }

  public Commitment type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public Commitment a(String a) {
    this.a = a;
    return this;
  }

   /**
   * a group element of the commitment
   * @return a
  **/
  @Schema(required = true, description = "a group element of the commitment")
  public String getA() {
    return a;
  }

  public void setA(String a) {
    this.a = a;
  }

  public Commitment b(String b) {
    this.b = b;
    return this;
  }

   /**
   * b group element of the commitment (needed for DHT protocol only)
   * @return b
  **/
  @Schema(description = "b group element of the commitment (needed for DHT protocol only)")
  public String getB() {
    return b;
  }

  public void setB(String b) {
    this.b = b;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Commitment commitment = (Commitment) o;
    return Objects.equals(this.hint, commitment.hint) &&
        Objects.equals(this.pubkey, commitment.pubkey) &&
        Objects.equals(this.position, commitment.position) &&
        Objects.equals(this.type, commitment.type) &&
        Objects.equals(this.a, commitment.a) &&
        Objects.equals(this.b, commitment.b);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hint, pubkey, position, type, a, b);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Commitment {\n");
    
    sb.append("    hint: ").append(toIndentedString(hint)).append("\n");
    sb.append("    pubkey: ").append(toIndentedString(pubkey)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    a: ").append(toIndentedString(a)).append("\n");
    sb.append("    b: ").append(toIndentedString(b)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
