/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.AvlTreeData;
import org.ergoplatform.restapi.client.ErgoLikeTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.PreHeader;
import org.ergoplatform.restapi.client.SigmaHeader;
/**
 * ErgoLikeContext
 */


public class ErgoLikeContext {
  @SerializedName("lastBlockUtxoRoot")
  private AvlTreeData lastBlockUtxoRoot = null;

  @SerializedName("headers")
  private java.util.List<SigmaHeader> headers = new java.util.ArrayList<SigmaHeader>();

  @SerializedName("preHeader")
  private PreHeader preHeader = null;

  @SerializedName("dataBoxes")
  private java.util.List<ErgoTransactionOutput> dataBoxes = new java.util.ArrayList<ErgoTransactionOutput>();

  @SerializedName("boxesToSpend")
  private java.util.List<ErgoTransactionOutput> boxesToSpend = new java.util.ArrayList<ErgoTransactionOutput>();

  @SerializedName("spendingTransaction")
  private ErgoLikeTransaction spendingTransaction = null;

  @SerializedName("selfIndex")
  private Long selfIndex = null;

  @SerializedName("extension")
  private Object extension = null;

  @SerializedName("validationSettings")
  private String validationSettings = null;

  @SerializedName("costLimit")
  private Long costLimit = null;

  @SerializedName("initCost")
  private Long initCost = null;

  public ErgoLikeContext lastBlockUtxoRoot(AvlTreeData lastBlockUtxoRoot) {
    this.lastBlockUtxoRoot = lastBlockUtxoRoot;
    return this;
  }

   /**
   * Get lastBlockUtxoRoot
   * @return lastBlockUtxoRoot
  **/
  @Schema(required = true, description = "")
  public AvlTreeData getLastBlockUtxoRoot() {
    return lastBlockUtxoRoot;
  }

  public void setLastBlockUtxoRoot(AvlTreeData lastBlockUtxoRoot) {
    this.lastBlockUtxoRoot = lastBlockUtxoRoot;
  }

  public ErgoLikeContext headers(java.util.List<SigmaHeader> headers) {
    this.headers = headers;
    return this;
  }

  public ErgoLikeContext addHeadersItem(SigmaHeader headersItem) {
    this.headers.add(headersItem);
    return this;
  }

   /**
   * fixed number of last block headers in descending order (first header is the newest one)
   * @return headers
  **/
  @Schema(required = true, description = "fixed number of last block headers in descending order (first header is the newest one)")
  public java.util.List<SigmaHeader> getHeaders() {
    return headers;
  }

  public void setHeaders(java.util.List<SigmaHeader> headers) {
    this.headers = headers;
  }

  public ErgoLikeContext preHeader(PreHeader preHeader) {
    this.preHeader = preHeader;
    return this;
  }

   /**
   * Get preHeader
   * @return preHeader
  **/
  @Schema(required = true, description = "")
  public PreHeader getPreHeader() {
    return preHeader;
  }

  public void setPreHeader(PreHeader preHeader) {
    this.preHeader = preHeader;
  }

  public ErgoLikeContext dataBoxes(java.util.List<ErgoTransactionOutput> dataBoxes) {
    this.dataBoxes = dataBoxes;
    return this;
  }

  public ErgoLikeContext addDataBoxesItem(ErgoTransactionOutput dataBoxesItem) {
    this.dataBoxes.add(dataBoxesItem);
    return this;
  }

   /**
   * boxes, that corresponds to id&#x27;s of &#x60;spendingTransaction.dataInputs&#x60;
   * @return dataBoxes
  **/
  @Schema(required = true, description = "boxes, that corresponds to id's of `spendingTransaction.dataInputs`")
  public java.util.List<ErgoTransactionOutput> getDataBoxes() {
    return dataBoxes;
  }

  public void setDataBoxes(java.util.List<ErgoTransactionOutput> dataBoxes) {
    this.dataBoxes = dataBoxes;
  }

  public ErgoLikeContext boxesToSpend(java.util.List<ErgoTransactionOutput> boxesToSpend) {
    this.boxesToSpend = boxesToSpend;
    return this;
  }

  public ErgoLikeContext addBoxesToSpendItem(ErgoTransactionOutput boxesToSpendItem) {
    this.boxesToSpend.add(boxesToSpendItem);
    return this;
  }

   /**
   * boxes, that corresponds to id&#x27;s of &#x60;spendingTransaction.inputs&#x60;
   * @return boxesToSpend
  **/
  @Schema(required = true, description = "boxes, that corresponds to id's of `spendingTransaction.inputs`")
  public java.util.List<ErgoTransactionOutput> getBoxesToSpend() {
    return boxesToSpend;
  }

  public void setBoxesToSpend(java.util.List<ErgoTransactionOutput> boxesToSpend) {
    this.boxesToSpend = boxesToSpend;
  }

  public ErgoLikeContext spendingTransaction(ErgoLikeTransaction spendingTransaction) {
    this.spendingTransaction = spendingTransaction;
    return this;
  }

   /**
   * Get spendingTransaction
   * @return spendingTransaction
  **/
  @Schema(required = true, description = "")
  public ErgoLikeTransaction getSpendingTransaction() {
    return spendingTransaction;
  }

  public void setSpendingTransaction(ErgoLikeTransaction spendingTransaction) {
    this.spendingTransaction = spendingTransaction;
  }

  public ErgoLikeContext selfIndex(Long selfIndex) {
    this.selfIndex = selfIndex;
    return this;
  }

   /**
   * index of the box in &#x60;boxesToSpend&#x60; that contains the script we&#x27;re evaluating
   * @return selfIndex
  **/
  @Schema(required = true, description = "index of the box in `boxesToSpend` that contains the script we're evaluating")
  public Long getSelfIndex() {
    return selfIndex;
  }

  public void setSelfIndex(Long selfIndex) {
    this.selfIndex = selfIndex;
  }

  public ErgoLikeContext extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * prover-defined key-value pairs, that may be used inside a script
   * @return extension
  **/
  @Schema(required = true, description = "prover-defined key-value pairs, that may be used inside a script")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public ErgoLikeContext validationSettings(String validationSettings) {
    this.validationSettings = validationSettings;
    return this;
  }

   /**
   * validation parameters passed to Interpreter.verify to detect soft-fork conditions
   * @return validationSettings
  **/
  @Schema(example = "10e8070001e9070001ea070001eb070001ec070001ed070001ee070001ef070001f0070001f1070001f2070001f3070001f4070001f5070001f6070001f7070001", required = true, description = "validation parameters passed to Interpreter.verify to detect soft-fork conditions")
  public String getValidationSettings() {
    return validationSettings;
  }

  public void setValidationSettings(String validationSettings) {
    this.validationSettings = validationSettings;
  }

  public ErgoLikeContext costLimit(Long costLimit) {
    this.costLimit = costLimit;
    return this;
  }

   /**
   * hard limit on accumulated execution cost, if exceeded lead to CostLimitException to be thrown
   * @return costLimit
  **/
  @Schema(required = true, description = "hard limit on accumulated execution cost, if exceeded lead to CostLimitException to be thrown")
  public Long getCostLimit() {
    return costLimit;
  }

  public void setCostLimit(Long costLimit) {
    this.costLimit = costLimit;
  }

  public ErgoLikeContext initCost(Long initCost) {
    this.initCost = initCost;
    return this;
  }

   /**
   * initial value of execution cost already accumulated before Interpreter.verify is called
   * @return initCost
  **/
  @Schema(required = true, description = "initial value of execution cost already accumulated before Interpreter.verify is called")
  public Long getInitCost() {
    return initCost;
  }

  public void setInitCost(Long initCost) {
    this.initCost = initCost;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ErgoLikeContext ergoLikeContext = (ErgoLikeContext) o;
    return Objects.equals(this.lastBlockUtxoRoot, ergoLikeContext.lastBlockUtxoRoot) &&
        Objects.equals(this.headers, ergoLikeContext.headers) &&
        Objects.equals(this.preHeader, ergoLikeContext.preHeader) &&
        Objects.equals(this.dataBoxes, ergoLikeContext.dataBoxes) &&
        Objects.equals(this.boxesToSpend, ergoLikeContext.boxesToSpend) &&
        Objects.equals(this.spendingTransaction, ergoLikeContext.spendingTransaction) &&
        Objects.equals(this.selfIndex, ergoLikeContext.selfIndex) &&
        Objects.equals(this.extension, ergoLikeContext.extension) &&
        Objects.equals(this.validationSettings, ergoLikeContext.validationSettings) &&
        Objects.equals(this.costLimit, ergoLikeContext.costLimit) &&
        Objects.equals(this.initCost, ergoLikeContext.initCost);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lastBlockUtxoRoot, headers, preHeader, dataBoxes, boxesToSpend, spendingTransaction, selfIndex, extension, validationSettings, costLimit, initCost);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ErgoLikeContext {\n");
    
    sb.append("    lastBlockUtxoRoot: ").append(toIndentedString(lastBlockUtxoRoot)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    preHeader: ").append(toIndentedString(preHeader)).append("\n");
    sb.append("    dataBoxes: ").append(toIndentedString(dataBoxes)).append("\n");
    sb.append("    boxesToSpend: ").append(toIndentedString(boxesToSpend)).append("\n");
    sb.append("    spendingTransaction: ").append(toIndentedString(spendingTransaction)).append("\n");
    sb.append("    selfIndex: ").append(toIndentedString(selfIndex)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    validationSettings: ").append(toIndentedString(validationSettings)).append("\n");
    sb.append("    costLimit: ").append(toIndentedString(costLimit)).append("\n");
    sb.append("    initCost: ").append(toIndentedString(initCost)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
