/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * Merkle proof for a leaf, which is an array of bytes (e.g. a transaction identifier)
 */
@Schema(description = "Merkle proof for a leaf, which is an array of bytes (e.g. a transaction identifier)")

public class MerkleProof {
  @SerializedName("leaf")
  private String leaf = null;

  @SerializedName("levels")
  private java.util.List<java.util.List> levels = new java.util.ArrayList<java.util.List>();

  public MerkleProof leaf(String leaf) {
    this.leaf = leaf;
    return this;
  }

   /**
   * Base16-encoded Merkle tree leaf bytes
   * @return leaf
  **/
  @Schema(example = "cd665e49c834b0c25574fcb19a158d836f3f2aad8e91ac195f972534c25449b3", required = true, description = "Base16-encoded Merkle tree leaf bytes")
  public String getLeaf() {
    return leaf;
  }

  public void setLeaf(String leaf) {
    this.leaf = leaf;
  }

  public MerkleProof levels(java.util.List<java.util.List> levels) {
    this.levels = levels;
    return this;
  }

  public MerkleProof addLevelsItem(java.util.List levelsItem) {
    this.levels.add(levelsItem);
    return this;
  }

   /**
   * Get levels
   * @return levels
  **/
  @Schema(example = "[[\"018b7ae20a4acd23e3f1bf38671ce97103ad96d8f1c780b5e5e865e4873ae16337\",0]]", required = true, description = "")
  public java.util.List<java.util.List> getLevels() {
    return levels;
  }

  public void setLevels(java.util.List<java.util.List> levels) {
    this.levels = levels;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerkleProof merkleProof = (MerkleProof) o;
    return Objects.equals(this.leaf, merkleProof.leaf) &&
        Objects.equals(this.levels, merkleProof.levels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(leaf, levels);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerkleProof {\n");
    
    sb.append("    leaf: ").append(toIndentedString(leaf)).append("\n");
    sb.append("    levels: ").append(toIndentedString(levels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
