/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.PopowHeader;
/**
 * NipopowProof
 */


public class NipopowProof {
  @SerializedName("m")
  private BigDecimal m = null;

  @SerializedName("k")
  private BigDecimal k = null;

  @SerializedName("prefix")
  private java.util.List<PopowHeader> prefix = new java.util.ArrayList<PopowHeader>();

  @SerializedName("suffixHead")
  private PopowHeader suffixHead = null;

  @SerializedName("suffixTail")
  private java.util.List<BlockHeader> suffixTail = new java.util.ArrayList<BlockHeader>();

  public NipopowProof m(BigDecimal m) {
    this.m = m;
    return this;
  }

   /**
   * security parameter (min μ-level superchain length)
   * @return m
  **/
  @Schema(required = true, description = "security parameter (min μ-level superchain length)")
  public BigDecimal getM() {
    return m;
  }

  public void setM(BigDecimal m) {
    this.m = m;
  }

  public NipopowProof k(BigDecimal k) {
    this.k = k;
    return this;
  }

   /**
   * security parameter (min suffix length, &gt;&#x3D; 1)
   * @return k
  **/
  @Schema(required = true, description = "security parameter (min suffix length, >= 1)")
  public BigDecimal getK() {
    return k;
  }

  public void setK(BigDecimal k) {
    this.k = k;
  }

  public NipopowProof prefix(java.util.List<PopowHeader> prefix) {
    this.prefix = prefix;
    return this;
  }

  public NipopowProof addPrefixItem(PopowHeader prefixItem) {
    this.prefix.add(prefixItem);
    return this;
  }

   /**
   * proof prefix headers
   * @return prefix
  **/
  @Schema(required = true, description = "proof prefix headers")
  public java.util.List<PopowHeader> getPrefix() {
    return prefix;
  }

  public void setPrefix(java.util.List<PopowHeader> prefix) {
    this.prefix = prefix;
  }

  public NipopowProof suffixHead(PopowHeader suffixHead) {
    this.suffixHead = suffixHead;
    return this;
  }

   /**
   * Get suffixHead
   * @return suffixHead
  **/
  @Schema(required = true, description = "")
  public PopowHeader getSuffixHead() {
    return suffixHead;
  }

  public void setSuffixHead(PopowHeader suffixHead) {
    this.suffixHead = suffixHead;
  }

  public NipopowProof suffixTail(java.util.List<BlockHeader> suffixTail) {
    this.suffixTail = suffixTail;
    return this;
  }

  public NipopowProof addSuffixTailItem(BlockHeader suffixTailItem) {
    this.suffixTail.add(suffixTailItem);
    return this;
  }

   /**
   * tail of the proof suffix headers
   * @return suffixTail
  **/
  @Schema(required = true, description = "tail of the proof suffix headers")
  public java.util.List<BlockHeader> getSuffixTail() {
    return suffixTail;
  }

  public void setSuffixTail(java.util.List<BlockHeader> suffixTail) {
    this.suffixTail = suffixTail;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NipopowProof nipopowProof = (NipopowProof) o;
    return Objects.equals(this.m, nipopowProof.m) &&
        Objects.equals(this.k, nipopowProof.k) &&
        Objects.equals(this.prefix, nipopowProof.prefix) &&
        Objects.equals(this.suffixHead, nipopowProof.suffixHead) &&
        Objects.equals(this.suffixTail, nipopowProof.suffixTail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(m, k, prefix, suffixHead, suffixTail);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NipopowProof {\n");
    
    sb.append("    m: ").append(toIndentedString(m)).append("\n");
    sb.append("    k: ").append(toIndentedString(k)).append("\n");
    sb.append("    prefix: ").append(toIndentedString(prefix)).append("\n");
    sb.append("    suffixHead: ").append(toIndentedString(suffixHead)).append("\n");
    sb.append("    suffixTail: ").append(toIndentedString(suffixTail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
