/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.Asset;
import org.ergoplatform.restapi.client.Registers;
/**
 * Request for generation of payment transaction to a given address
 */
@Schema(description = "Request for generation of payment transaction to a given address")

public class PaymentRequest implements AnyOfRequestsHolderRequestsItems {
  @SerializedName("address")
  private String address = null;

  @SerializedName("value")
  private Long value = null;

  @SerializedName("assets")
  private java.util.List<Asset> assets = null;

  @SerializedName("registers")
  private Registers registers = null;

  public PaymentRequest address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @Schema(required = true, description = "")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public PaymentRequest value(Long value) {
    this.value = value;
    return this;
  }

   /**
   * Payment amount
   * @return value
  **/
  @Schema(example = "1", required = true, description = "Payment amount")
  public Long getValue() {
    return value;
  }

  public void setValue(Long value) {
    this.value = value;
  }

  public PaymentRequest assets(java.util.List<Asset> assets) {
    this.assets = assets;
    return this;
  }

  public PaymentRequest addAssetsItem(Asset assetsItem) {
    if (this.assets == null) {
      this.assets = new java.util.ArrayList<Asset>();
    }
    this.assets.add(assetsItem);
    return this;
  }

   /**
   * Assets list in the transaction
   * @return assets
  **/
  @Schema(description = "Assets list in the transaction")
  public java.util.List<Asset> getAssets() {
    return assets;
  }

  public void setAssets(java.util.List<Asset> assets) {
    this.assets = assets;
  }

  public PaymentRequest registers(Registers registers) {
    this.registers = registers;
    return this;
  }

   /**
   * Get registers
   * @return registers
  **/
  @Schema(description = "")
  public Registers getRegisters() {
    return registers;
  }

  public void setRegisters(Registers registers) {
    this.registers = registers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentRequest paymentRequest = (PaymentRequest) o;
    return Objects.equals(this.address, paymentRequest.address) &&
        Objects.equals(this.value, paymentRequest.value) &&
        Objects.equals(this.assets, paymentRequest.assets) &&
        Objects.equals(this.registers, paymentRequest.registers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, value, assets, registers);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentRequest {\n");
    
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    assets: ").append(toIndentedString(assets)).append("\n");
    sb.append("    registers: ").append(toIndentedString(registers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
