/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.ErgoTransactionDataInput;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
/**
 * Transaction augmented with some useful information
 */
@Schema(description = "Transaction augmented with some useful information")

public class WalletTransaction {
  @SerializedName("id")
  private String id = null;

  @SerializedName("inputs")
  private java.util.List<ErgoTransactionInput> inputs = new java.util.ArrayList<ErgoTransactionInput>();

  @SerializedName("dataInputs")
  private java.util.List<ErgoTransactionDataInput> dataInputs = new java.util.ArrayList<ErgoTransactionDataInput>();

  @SerializedName("outputs")
  private java.util.List<ErgoTransactionOutput> outputs = new java.util.ArrayList<ErgoTransactionOutput>();

  @SerializedName("inclusionHeight")
  private Integer inclusionHeight = null;

  @SerializedName("numConfirmations")
  private Integer numConfirmations = null;

  @SerializedName("scans")
  private java.util.List<Integer> scans = new java.util.ArrayList<Integer>();

  @SerializedName("size")
  private Integer size = null;

  public WalletTransaction id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public WalletTransaction inputs(java.util.List<ErgoTransactionInput> inputs) {
    this.inputs = inputs;
    return this;
  }

  public WalletTransaction addInputsItem(ErgoTransactionInput inputsItem) {
    this.inputs.add(inputsItem);
    return this;
  }

   /**
   * Transaction inputs
   * @return inputs
  **/
  @Schema(required = true, description = "Transaction inputs")
  public java.util.List<ErgoTransactionInput> getInputs() {
    return inputs;
  }

  public void setInputs(java.util.List<ErgoTransactionInput> inputs) {
    this.inputs = inputs;
  }

  public WalletTransaction dataInputs(java.util.List<ErgoTransactionDataInput> dataInputs) {
    this.dataInputs = dataInputs;
    return this;
  }

  public WalletTransaction addDataInputsItem(ErgoTransactionDataInput dataInputsItem) {
    this.dataInputs.add(dataInputsItem);
    return this;
  }

   /**
   * Transaction data inputs
   * @return dataInputs
  **/
  @Schema(required = true, description = "Transaction data inputs")
  public java.util.List<ErgoTransactionDataInput> getDataInputs() {
    return dataInputs;
  }

  public void setDataInputs(java.util.List<ErgoTransactionDataInput> dataInputs) {
    this.dataInputs = dataInputs;
  }

  public WalletTransaction outputs(java.util.List<ErgoTransactionOutput> outputs) {
    this.outputs = outputs;
    return this;
  }

  public WalletTransaction addOutputsItem(ErgoTransactionOutput outputsItem) {
    this.outputs.add(outputsItem);
    return this;
  }

   /**
   * Transaction outputs
   * @return outputs
  **/
  @Schema(required = true, description = "Transaction outputs")
  public java.util.List<ErgoTransactionOutput> getOutputs() {
    return outputs;
  }

  public void setOutputs(java.util.List<ErgoTransactionOutput> outputs) {
    this.outputs = outputs;
  }

  public WalletTransaction inclusionHeight(Integer inclusionHeight) {
    this.inclusionHeight = inclusionHeight;
    return this;
  }

   /**
   * Height of a block the transaction was included in
   * @return inclusionHeight
  **/
  @Schema(example = "20998", required = true, description = "Height of a block the transaction was included in")
  public Integer getInclusionHeight() {
    return inclusionHeight;
  }

  public void setInclusionHeight(Integer inclusionHeight) {
    this.inclusionHeight = inclusionHeight;
  }

  public WalletTransaction numConfirmations(Integer numConfirmations) {
    this.numConfirmations = numConfirmations;
    return this;
  }

   /**
   * Number of transaction confirmations
   * @return numConfirmations
  **/
  @Schema(example = "20998", required = true, description = "Number of transaction confirmations")
  public Integer getNumConfirmations() {
    return numConfirmations;
  }

  public void setNumConfirmations(Integer numConfirmations) {
    this.numConfirmations = numConfirmations;
  }

  public WalletTransaction scans(java.util.List<Integer> scans) {
    this.scans = scans;
    return this;
  }

  public WalletTransaction addScansItem(Integer scansItem) {
    this.scans.add(scansItem);
    return this;
  }

   /**
   * Scan identifiers the transaction relates to
   * @return scans
  **/
  @Schema(required = true, description = "Scan identifiers the transaction relates to")
  public java.util.List<Integer> getScans() {
    return scans;
  }

  public void setScans(java.util.List<Integer> scans) {
    this.scans = scans;
  }

  public WalletTransaction size(Integer size) {
    this.size = size;
    return this;
  }

   /**
   * Size in bytes
   * @return size
  **/
  @Schema(description = "Size in bytes")
  public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WalletTransaction walletTransaction = (WalletTransaction) o;
    return Objects.equals(this.id, walletTransaction.id) &&
        Objects.equals(this.inputs, walletTransaction.inputs) &&
        Objects.equals(this.dataInputs, walletTransaction.dataInputs) &&
        Objects.equals(this.outputs, walletTransaction.outputs) &&
        Objects.equals(this.inclusionHeight, walletTransaction.inclusionHeight) &&
        Objects.equals(this.numConfirmations, walletTransaction.numConfirmations) &&
        Objects.equals(this.scans, walletTransaction.scans) &&
        Objects.equals(this.size, walletTransaction.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, inputs, dataInputs, outputs, inclusionHeight, numConfirmations, scans, size);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WalletTransaction {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    dataInputs: ").append(toIndentedString(dataInputs)).append("\n");
    sb.append("    outputs: ").append(toIndentedString(outputs)).append("\n");
    sb.append("    inclusionHeight: ").append(toIndentedString(inclusionHeight)).append("\n");
    sb.append("    numConfirmations: ").append(toIndentedString(numConfirmations)).append("\n");
    sb.append("    scans: ").append(toIndentedString(scans)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
