/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Strings;
import java.util.function.Function;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BlockchainDataSource;
import org.ergoplatform.appkit.ErgoClient;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.config.ErgoNodeConfig;
import org.ergoplatform.appkit.impl.BlockchainContextBuilderImpl;
import org.ergoplatform.appkit.impl.NodeAndExplorerDataSourceImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.restapi.client.ApiClient;

public class RestApiErgoClient
implements ErgoClient {
    private final NetworkType _networkType;
    private final NodeAndExplorerDataSourceImpl apiClient;
    public static final String defaultMainnetExplorerUrl = "https://api.ergoplatform.com";
    public static final String defaultTestnetExplorerUrl = "https://api-testnet.ergoplatform.com";

    RestApiErgoClient(String string, NetworkType networkType, String string2, String string3, @Nullable OkHttpClient.Builder builder) {
        ExplorerApiClient explorerApiClient;
        this._networkType = networkType;
        if (builder == null) {
            builder = new OkHttpClient().newBuilder();
        }
        ApiClient apiClient = new ApiClient(string, "ApiKeyAuth", string2);
        apiClient.configureFromOkClientBuilder(builder);
        if (!Strings.isNullOrEmpty((String)string3)) {
            explorerApiClient = new ExplorerApiClient(string3);
            explorerApiClient.configureFromOkClientBuilder(builder);
        } else {
            explorerApiClient = null;
        }
        this.apiClient = new NodeAndExplorerDataSourceImpl(apiClient, explorerApiClient);
    }

    @Override
    public <T> T execute(Function<BlockchainContext, T> function) {
        BlockchainContext blockchainContext = new BlockchainContextBuilderImpl(this.apiClient, this._networkType).build();
        T t = function.apply(blockchainContext);
        return t;
    }

    public static String getDefaultExplorerUrl(NetworkType networkType) {
        switch (networkType) {
            case MAINNET: {
                return defaultMainnetExplorerUrl;
            }
        }
        return defaultTestnetExplorerUrl;
    }

    public static ErgoClient createWithoutExplorer(String string, NetworkType networkType, String string2) {
        return new RestApiErgoClient(string, networkType, string2, null, null);
    }

    public static ErgoClient create(String string, NetworkType networkType, String string2, String string3) {
        return new RestApiErgoClient(string, networkType, string2, string3, null);
    }

    public static ErgoClient createWithHttpClientBuilder(String string, NetworkType networkType, String string2, String string3, @Nullable OkHttpClient.Builder builder) {
        return new RestApiErgoClient(string, networkType, string2, string3, builder);
    }

    public static ErgoClient create(ErgoNodeConfig ergoNodeConfig, String string) {
        return RestApiErgoClient.create(ergoNodeConfig.getNodeApi().getApiUrl(), ergoNodeConfig.getNetworkType(), ergoNodeConfig.getNodeApi().getApiKey(), string);
    }

    public static ErgoClient createWithHttpClientBuilder(ErgoNodeConfig ergoNodeConfig, String string, @Nullable OkHttpClient.Builder builder) {
        return RestApiErgoClient.createWithHttpClientBuilder(ergoNodeConfig.getNodeApi().getApiUrl(), ergoNodeConfig.getNetworkType(), ergoNodeConfig.getNodeApi().getApiKey(), string, builder);
    }

    @Override
    public BlockchainDataSource getDataSource() {
        return this.apiClient;
    }
}

