/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.ergoplatform.restapi.client.SigmaBoolean;

@Schema(description="basic trait for prover commitments")
public class Commitment {
    @SerializedName(value="hint")
    private HintEnum hint = null;
    @SerializedName(value="pubkey")
    private SigmaBoolean pubkey = null;
    @SerializedName(value="position")
    private String position = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="a")
    private String a = null;
    @SerializedName(value="b")
    private String b = null;

    public Commitment hint(HintEnum hintEnum) {
        this.hint = hintEnum;
        return this;
    }

    @Schema(required=true, description="")
    public HintEnum getHint() {
        return this.hint;
    }

    public void setHint(HintEnum hintEnum) {
        this.hint = hintEnum;
    }

    public Commitment pubkey(SigmaBoolean sigmaBoolean) {
        this.pubkey = sigmaBoolean;
        return this;
    }

    @Schema(required=true, description="")
    public SigmaBoolean getPubkey() {
        return this.pubkey;
    }

    public void setPubkey(SigmaBoolean sigmaBoolean) {
        this.pubkey = sigmaBoolean;
    }

    public Commitment position(String string) {
        this.position = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        this.position = string;
    }

    public Commitment type(TypeEnum typeEnum) {
        this.type = typeEnum;
        return this;
    }

    @Schema(description="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum typeEnum) {
        this.type = typeEnum;
    }

    public Commitment a(String string) {
        this.a = string;
        return this;
    }

    @Schema(required=true, description="a group element of the commitment")
    public String getA() {
        return this.a;
    }

    public void setA(String string) {
        this.a = string;
    }

    public Commitment b(String string) {
        this.b = string;
        return this;
    }

    @Schema(description="b group element of the commitment (needed for DHT protocol only)")
    public String getB() {
        return this.b;
    }

    public void setB(String string) {
        this.b = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Commitment commitment = (Commitment)object;
        return Objects.equals((Object)this.hint, (Object)commitment.hint) && Objects.equals(this.pubkey, commitment.pubkey) && Objects.equals(this.position, commitment.position) && Objects.equals((Object)this.type, (Object)commitment.type) && Objects.equals(this.a, commitment.a) && Objects.equals(this.b, commitment.b);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hint, this.pubkey, this.position, this.type, this.a, this.b});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Commitment {\n");
        stringBuilder.append("    hint: ").append(this.toIndentedString((Object)this.hint)).append("\n");
        stringBuilder.append("    pubkey: ").append(this.toIndentedString(this.pubkey)).append("\n");
        stringBuilder.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        stringBuilder.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        stringBuilder.append("    a: ").append(this.toIndentedString(this.a)).append("\n");
        stringBuilder.append("    b: ").append(this.toIndentedString(this.b)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DLOG("dlog"),
        DHT("dht");

        private String value;

        private TypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String string) {
            for (TypeEnum typeEnum : TypeEnum.values()) {
                if (!String.valueOf(typeEnum.value).equals(string)) continue;
                return typeEnum;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum typeEnum) throws IOException {
                jsonWriter.value(typeEnum.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(string));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HintEnum {
        CMTWITHSECRET("cmtWithSecret"),
        CMTREAL("cmtReal"),
        CMTSIMULATED("cmtSimulated");

        private String value;

        private HintEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HintEnum fromValue(String string) {
            for (HintEnum hintEnum : HintEnum.values()) {
                if (!String.valueOf(hintEnum.value).equals(string)) continue;
                return hintEnum;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HintEnum> {
            public void write(JsonWriter jsonWriter, HintEnum hintEnum) throws IOException {
                jsonWriter.value(hintEnum.getValue());
            }

            public HintEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return HintEnum.fromValue(String.valueOf(string));
            }
        }
    }
}

