/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxOperations;
import org.ergoplatform.appkit.ConstantsBuilder;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import special.sigma.GroupElement;

public final class DhtUtils$ {
    public static DhtUtils$ MODULE$;

    static {
        new DhtUtils$();
    }

    public SignedTransaction createDhtBox(BlockchainContext ctx, ErgoProver sender, long amountToSend, GroupElement g_x) {
        ErgoContract contract = ctx.compileContract(ConstantsBuilder.create().item("g_x", (Object)g_x).build(), new StringOps(Predef$.MODULE$.augmentString("{\n       |  val g_y = OUTPUTS(0).R4[GroupElement].get\n       |  val g_xy = OUTPUTS(0).R5[GroupElement].get\n       |\n       |  proveDHTuple(groupGenerator, g_x, g_y, g_xy) || // for bob\n       |  proveDHTuple(groupGenerator, g_y, g_x, g_xy)    // for alice\n       |}")).stripMargin());
        SignedTransaction dhtBoxCreationTx = BoxOperations.createForProver((ErgoProver)sender, (BlockchainContext)ctx).withAmountToSpend(amountToSend).putToContractTx(contract);
        return dhtBoxCreationTx;
    }

    public SignedTransaction spendDhtBox(BlockchainContext ctx, GroupElement g_y, GroupElement g_xy, ErgoProver sender, InputBox dhtBox, Address receiver) {
        UnsignedTransaction tx = BoxOperations.createForSender((Address)sender.getAddress(), (BlockchainContext)ctx).buildTxWithDefaultInputs(txB -> {
            OutBox outBox = txB.outBoxBuilder().value(dhtBox.getValue()).contract(receiver.toErgoContract()).registers(new ErgoValue[]{ErgoValue.of((GroupElement)g_y), ErgoValue.of((GroupElement)g_xy)}).build();
            txB.outputs(new OutBox[]{outBox});
            return txB;
        });
        return sender.sign(tx);
    }

    private DhtUtils$() {
        MODULE$ = this;
    }
}

