/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.BlockTransactions;
import org.ergoplatform.restapi.client.BlocksApi;
import org.ergoplatform.restapi.client.FullBlock;
import org.ergoplatform.restapi.client.MerkleProof;
import org.ergoplatform.restapi.client.PeerFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlocksApiTest
extends PeerFinder {
    private BlocksApi api;

    @Before
    public void setup() {
        this.api = (BlocksApi)this.findPeer(true).createService(BlocksApi.class);
    }

    @Test
    public void getBlockHeaderByIdTest() throws IOException {
        String string = this.blockId;
        BlockHeader blockHeader = (BlockHeader)this.api.getBlockHeaderById(string).execute().body();
        Assert.assertNotNull((Object)blockHeader);
        Assert.assertTrue((blockHeader.getHeight() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void getBlockTransactionsByIdTest() throws IOException {
        String string = this.blockId;
        BlockTransactions blockTransactions = (BlockTransactions)this.api.getBlockTransactionsById(string).execute().body();
        Assert.assertNotNull((Object)blockTransactions);
        Assert.assertTrue((blockTransactions.getSize() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getChainSliceTest() throws IOException {
        Integer n = 1;
        Integer n2 = 20;
        List list = (List)this.api.getChainSlice(n, n2).execute().body();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)19L, (long)list.size());
    }

    @Test
    public void getFullBlockAtTest() throws IOException {
        Integer n = 1;
        List list = (List)this.api.getFullBlockAt(n).execute().body();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void getFullBlockByIdTest() throws IOException {
        String string = this.blockId;
        FullBlock fullBlock = (FullBlock)this.api.getFullBlockById(string).execute().body();
        Assert.assertNotNull((Object)fullBlock);
        Assert.assertEquals((Object)string, (Object)fullBlock.getHeader().getId());
    }

    @Test
    public void getHeaderIdsTest() throws IOException {
        Integer n = 10;
        Integer n2 = 1;
        List list = (List)this.api.getHeaderIds(n, n2).execute().body();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)10L, (long)list.size());
    }

    @Test
    public void getLastHeadersTest() throws IOException {
        BigDecimal bigDecimal = BigDecimal.valueOf(10L);
        List list = (List)this.api.getLastHeaders(bigDecimal).execute().body();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)10L, (long)list.size());
    }

    @Test
    public void getModifierByIdTest() throws IOException {
        String string = this.txId;
        Void void_ = (Void)this.api.getModifierById(string).execute().body();
        Assert.assertNull((Object)void_);
    }

    @Test
    public void getProofForTxTest() throws IOException {
        String string = this.blockId;
        String string2 = this.txFromTheBlockId;
        MerkleProof merkleProof = (MerkleProof)this.api.getProofForTx(string, string2).execute().body();
        Assert.assertNotNull((Object)merkleProof);
        Assert.assertTrue((merkleProof.getLevels().size() == 2 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sendMinedBlockTest() throws IOException {
        FullBlock fullBlock = null;
        Void void_ = (Void)this.api.sendMinedBlock(fullBlock).execute().body();
    }
}

