/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.babelfee;

import java.util.List;
import javax.annotation.Nullable;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.SigmaProp;
import org.ergoplatform.appkit.TransactionBox;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.babelfee.BabelFeeBoxContract;
import org.ergoplatform.appkit.babelfee.BabelFeeBoxStateBuilder;
import org.ergoplatform.appkit.impl.ErgoTreeContract;

public class BabelFeeBoxState {
    private final long pricePerToken;
    private final ErgoId tokenId;
    private final SigmaProp boxCreator;
    private final long value;
    private final long tokenAmount;

    public BabelFeeBoxState(TransactionBox transactionBox) {
        this.value = transactionBox.getValue();
        List<ErgoValue<?>> list = transactionBox.getRegisters();
        this.boxCreator = new SigmaProp((special.sigma.SigmaProp)list.get(0).getValue());
        this.pricePerToken = (Long)list.get(1).getValue();
        this.tokenId = new BabelFeeBoxContract(transactionBox.getErgoTree()).getTokenId();
        if (!transactionBox.getTokens().isEmpty()) {
            ErgoToken ergoToken = transactionBox.getTokens().get(0);
            this.tokenAmount = ergoToken.getValue();
            if (!ergoToken.getId().equals(this.tokenId)) {
                throw new IllegalStateException("Token id of contract and token id in babel box should be equial.");
            }
        } else {
            this.tokenAmount = 0L;
        }
    }

    BabelFeeBoxState(long l, ErgoId ergoId, SigmaProp sigmaProp, long l2, long l3) {
        this.pricePerToken = l;
        this.tokenId = ergoId;
        this.boxCreator = sigmaProp;
        this.value = l2;
        this.tokenAmount = l3;
    }

    public long getPricePerToken() {
        return this.pricePerToken;
    }

    public ErgoId getTokenId() {
        return this.tokenId;
    }

    public SigmaProp getBoxCreator() {
        return this.boxCreator;
    }

    public long getValue() {
        return this.value;
    }

    public long getTokenAmount() {
        return this.tokenAmount;
    }

    public long getValueAvailableToBuy() {
        return this.value - 1000000L;
    }

    public long getMaxTokenAmountToBuy() {
        return this.getValueAvailableToBuy() / this.pricePerToken;
    }

    public long calcTokensToSellForErgAmount(long l) {
        long l2 = l / this.pricePerToken;
        return l2 * this.pricePerToken >= l ? l2 : l2 + 1L;
    }

    public BabelFeeBoxState buildSucceedingState(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("tokenAmountChange must be greater than 0");
        }
        if (l > this.getMaxTokenAmountToBuy()) {
            throw new IllegalArgumentException("tokenAmountChange must be less or equal maxAmountToBuy");
        }
        return new BabelFeeBoxState(this.pricePerToken, this.tokenId, this.boxCreator, this.value - l * this.pricePerToken, l + this.tokenAmount);
    }

    public OutBox buildOutbox(UnsignedTransactionBuilder unsignedTransactionBuilder, @Nullable InputBox inputBox) {
        OutBoxBuilder outBoxBuilder = unsignedTransactionBuilder.outBoxBuilder().contract(new ErgoTreeContract(new BabelFeeBoxContract(this.tokenId).getErgoTree(), unsignedTransactionBuilder.getNetworkType())).value(this.value).registers(ErgoValue.of(this.boxCreator), ErgoValue.of(this.pricePerToken), ErgoValue.of(inputBox != null ? inputBox.getId().getBytes() : new byte[]{}));
        if (this.tokenAmount > 0L) {
            outBoxBuilder.tokens(new ErgoToken(this.tokenId, this.tokenAmount));
        }
        return outBoxBuilder.build();
    }

    public static BabelFeeBoxStateBuilder newBuilder() {
        return new BabelFeeBoxStateBuilder();
    }
}

