/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.Input;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockHeader;
import org.ergoplatform.appkit.BlockchainDataSource;
import org.ergoplatform.appkit.BlockchainParameters;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.Transaction;
import org.ergoplatform.appkit.impl.BlockHeaderImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.NodeInfoParameters;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import org.ergoplatform.explorer.client.DefaultApi;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.explorer.client.model.OutputInfo;
import org.ergoplatform.explorer.client.model.TransactionInfo;
import org.ergoplatform.restapi.client.ApiClient;
import org.ergoplatform.restapi.client.BlocksApi;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionDataInput;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.InfoApi;
import org.ergoplatform.restapi.client.NodeInfo;
import org.ergoplatform.restapi.client.Transactions;
import org.ergoplatform.restapi.client.TransactionsApi;
import org.ergoplatform.restapi.client.UtxoApi;
import org.ergoplatform.restapi.client.WalletApi;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import scala.collection.IndexedSeq;

public class NodeAndExplorerDataSourceImpl
implements BlockchainDataSource {
    private final InfoApi nodeInfoApi;
    private final BlocksApi nodeBlocksApi;
    private final UtxoApi nodeUtxoApi;
    private final TransactionsApi nodeTransactionsApi;
    private final WalletApi nodeWalletApi;
    private final DefaultApi explorerApi;
    private BlockchainParameters blockchainParameters;
    public boolean performCheckBeforeSend = false;

    public NodeAndExplorerDataSourceImpl(ApiClient apiClient, ExplorerApiClient explorerApiClient) {
        OkHttpClient okHttpClient = apiClient.getOkBuilder().build();
        Retrofit retrofit = apiClient.getAdapterBuilder().client(okHttpClient).build();
        this.nodeInfoApi = (InfoApi)retrofit.create(InfoApi.class);
        this.nodeBlocksApi = (BlocksApi)retrofit.create(BlocksApi.class);
        this.nodeUtxoApi = (UtxoApi)retrofit.create(UtxoApi.class);
        this.nodeTransactionsApi = (TransactionsApi)retrofit.create(TransactionsApi.class);
        this.nodeWalletApi = (WalletApi)retrofit.create(WalletApi.class);
        if (explorerApiClient != null) {
            OkHttpClient okHttpClient2 = explorerApiClient.getOkBuilder().build();
            Retrofit retrofit2 = explorerApiClient.getAdapterBuilder().client(okHttpClient2).build();
            this.explorerApi = (DefaultApi)retrofit2.create(DefaultApi.class);
        } else {
            this.explorerApi = null;
        }
    }

    @Override
    public BlockchainParameters getParameters() {
        if (this.blockchainParameters == null) {
            this.getNodeInfo();
        }
        return this.blockchainParameters;
    }

    private NodeInfo getNodeInfo() {
        NodeInfo nodeInfo = this.executeCall(this.nodeInfoApi.getNodeInfo());
        this.blockchainParameters = new NodeInfoParameters(nodeInfo);
        return nodeInfo;
    }

    @Override
    public List<BlockHeader> getLastBlockHeaders(int n, boolean bl) {
        List<org.ergoplatform.restapi.client.BlockHeader> list;
        Object object;
        if (bl) {
            object = this.getNodeInfo();
            int n2 = ((NodeInfo)object).getFullHeight();
            int n3 = ((NodeInfo)object).getHeadersHeight();
            int n4 = Math.max(0, n3 - n2);
            List<org.ergoplatform.restapi.client.BlockHeader> list2 = this.executeCall(this.nodeBlocksApi.getLastHeaders(BigDecimal.valueOf(n + n4)));
            list = new ArrayList<org.ergoplatform.restapi.client.BlockHeader>();
            for (org.ergoplatform.restapi.client.BlockHeader blockHeader : list2) {
                if (blockHeader.getHeight() > n2) continue;
                list.add(blockHeader);
            }
            if (list.isEmpty()) {
                throw new IllegalStateException("onlyFullHeaders set, but all returned headers are not within range.");
            }
        } else {
            list = this.executeCall(this.nodeBlocksApi.getLastHeaders(BigDecimal.valueOf(n)));
        }
        Collections.reverse(list);
        object = new ArrayList(list.size());
        for (org.ergoplatform.restapi.client.BlockHeader blockHeader : list) {
            object.add(BlockHeaderImpl.createFromRestApi(blockHeader));
        }
        return object;
    }

    @Override
    public InputBox getBoxById(String string, boolean bl, boolean bl2) {
        if (bl2 && !bl) {
            return this.getBoxByIdExplorer(string);
        }
        if (!bl2) {
            return this.getUnspentBoxByIdNode(string, bl);
        }
        try {
            return this.getUnspentBoxByIdNode(string, bl);
        }
        catch (Throwable throwable) {
            return this.getBoxByIdExplorer(string);
        }
    }

    private InputBox getUnspentBoxByIdNode(String string, boolean bl) {
        ErgoTransactionOutput ergoTransactionOutput = bl ? this.executeCall(this.nodeUtxoApi.getBoxWithPoolById(string)) : this.executeCall(this.nodeUtxoApi.getBoxById(string));
        return new InputBoxImpl(ergoTransactionOutput);
    }

    private InputBox getBoxByIdExplorer(String string) {
        OutputInfo outputInfo = this.executeCall(this.explorerApi.getApiV1BoxesP1(string));
        return new InputBoxImpl(outputInfo);
    }

    @Override
    public String sendTransaction(SignedTransaction signedTransaction) {
        ErgoLikeTransaction ergoLikeTransaction = ((SignedTransactionImpl)signedTransaction).getTx();
        List<ErgoTransactionDataInput> list = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionDataInput()).from((IndexedSeq<DataInput>)ergoLikeTransaction.dataInputs());
        List<ErgoTransactionInput> list2 = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionInput()).from((IndexedSeq<Input>)ergoLikeTransaction.inputs());
        List<ErgoTransactionOutput> list3 = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionOutput()).from((IndexedSeq<ErgoBox>)ergoLikeTransaction.outputs());
        ErgoTransaction ergoTransaction = new ErgoTransaction().id(ergoLikeTransaction.id()).dataInputs(list).inputs(list2).outputs(list3);
        if (this.performCheckBeforeSend) {
            String string = this.executeCall(this.nodeTransactionsApi.checkTransaction(ergoTransaction)).replace("\"", "");
            if (!ergoTransaction.getId().equals(string)) {
                throw new IllegalStateException("checkTransaction returned tx id " + string + ", expected was " + ergoTransaction.getId());
            }
        }
        return this.executeCall(this.nodeTransactionsApi.sendTransaction(ergoTransaction));
    }

    @Override
    public List<InputBox> getUnspentBoxesFor(Address address, int n, int n2) {
        Preconditions.checkNotNull((Object)this.explorerApi, (Object)"Explorer URL is not specified when RestApiErgoClient.create() is called.");
        List<OutputInfo> list = this.executeCall(this.explorerApi.getApiV1BoxesUnspentByaddressP1(address.toString(), n, n2, "asc")).getItems();
        return this.getInputBoxes(list);
    }

    @Override
    public List<InputBox> getUnconfirmedUnspentBoxesFor(Address address, int n, int n2) {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        String string = address.toString();
        List<TransactionInfo> list = this.executeCall(this.getExplorerApi().getApiV1MempoolTransactionsByaddressP1(string, n, n2)).getItems();
        for (TransactionInfo transactionInfo : list) {
            for (OutputInfo outputInfo : transactionInfo.getOutputs()) {
                if (!outputInfo.getAddress().equals(string) || outputInfo.getSpentTransactionId() != null) continue;
                try {
                    InputBox inputBox = this.getBoxById(outputInfo.getBoxId(), true, false);
                    if (inputBox == null) continue;
                    arrayList.add(inputBox);
                }
                catch (ErgoClientException ergoClientException) {}
            }
        }
        return arrayList;
    }

    @Override
    public List<Transaction> getUnconfirmedTransactions(int n, int n2) {
        Transactions transactions = this.executeCall(this.getNodeTransactionsApi().getUnconfirmedTransactions(n2, n));
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>(transactions.size());
        for (ErgoTransaction ergoTransaction : transactions) {
            arrayList.add(new MempoolTransaction(ergoTransaction));
        }
        return arrayList;
    }

    private List<InputBox> getInputBoxes(List<OutputInfo> list) {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(list.size());
        for (OutputInfo outputInfo : list) {
            String string = outputInfo.getBoxId();
            try {
                InputBox inputBox = this.getBoxById(string, false, false);
                if (inputBox == null) continue;
                arrayList.add(inputBox);
            }
            catch (ErgoClientException ergoClientException) {}
        }
        return arrayList;
    }

    protected <T> T executeCall(Call<T> call) throws ErgoClientException {
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                throw new ErgoClientException(response.code() + ": " + (response.errorBody() != null ? response.errorBody().string() : "Server returned error"), null);
            }
            return (T)response.body();
        }
        catch (Exception exception) {
            throw new ErgoClientException(String.format("Error executing API request to %s: %s", call.request().url(), exception.getMessage()), exception);
        }
    }

    public InfoApi getNodeInfoApi() {
        return this.nodeInfoApi;
    }

    public BlocksApi getNodeBlocksApi() {
        return this.nodeBlocksApi;
    }

    public UtxoApi getNodeUtxoApi() {
        return this.nodeUtxoApi;
    }

    public TransactionsApi getNodeTransactionsApi() {
        return this.nodeTransactionsApi;
    }

    public WalletApi getNodeWalletApi() {
        return this.nodeWalletApi;
    }

    public DefaultApi getExplorerApi() {
        return this.explorerApi;
    }

    private static class MempoolTransaction
    implements Transaction {
        private final ErgoTransaction tx;

        public MempoolTransaction(ErgoTransaction ergoTransaction) {
            this.tx = ergoTransaction;
        }

        @Override
        public String getId() {
            return this.tx.getId();
        }

        @Override
        public List<String> getInputBoxesIds() {
            ArrayList<String> arrayList = new ArrayList<String>(this.tx.getInputs().size());
            for (ErgoTransactionInput ergoTransactionInput : this.tx.getInputs()) {
                arrayList.add(ergoTransactionInput.getBoxId());
            }
            return arrayList;
        }

        @Override
        public List<OutBox> getOutputs() {
            ArrayList<OutBox> arrayList = new ArrayList<OutBox>(this.tx.getOutputs().size());
            for (ErgoTransactionOutput ergoTransactionOutput : this.tx.getOutputs()) {
                arrayList.add(new OutBoxImpl((ErgoBoxCandidate)ScalaBridge.isoErgoTransactionOutput().to(ergoTransactionOutput)));
            }
            return arrayList;
        }
    }
}

