/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.Registers;
/**
 * Request for generation of asset issue transaction
 */
@Schema(description = "Request for generation of asset issue transaction")

public class AssetIssueRequest implements AnyOfRequestsHolderRequestsItems {
  @SerializedName("address")
  private String address = null;

  @SerializedName("ergValue")
  private Integer ergValue = null;

  @SerializedName("amount")
  private Long amount = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("decimals")
  private Integer decimals = null;

  @SerializedName("registers")
  private Registers registers = null;

  public AssetIssueRequest address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @Schema(description = "")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public AssetIssueRequest ergValue(Integer ergValue) {
    this.ergValue = ergValue;
    return this;
  }

   /**
   * Optional, amount of ergs to be put into box with issued assets
   * @return ergValue
  **/
  @Schema(description = "Optional, amount of ergs to be put into box with issued assets")
  public Integer getErgValue() {
    return ergValue;
  }

  public void setErgValue(Integer ergValue) {
    this.ergValue = ergValue;
  }

  public AssetIssueRequest amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Supply amount
   * @return amount
  **/
  @Schema(example = "1000000", required = true, description = "Supply amount")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public AssetIssueRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Assets name
   * @return name
  **/
  @Schema(example = "TST", required = true, description = "Assets name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AssetIssueRequest description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Assets description
   * @return description
  **/
  @Schema(example = "Test token", required = true, description = "Assets description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AssetIssueRequest decimals(Integer decimals) {
    this.decimals = decimals;
    return this;
  }

   /**
   * Number of decimal places
   * @return decimals
  **/
  @Schema(example = "8", required = true, description = "Number of decimal places")
  public Integer getDecimals() {
    return decimals;
  }

  public void setDecimals(Integer decimals) {
    this.decimals = decimals;
  }

  public AssetIssueRequest registers(Registers registers) {
    this.registers = registers;
    return this;
  }

   /**
   * Get registers
   * @return registers
  **/
  @Schema(description = "")
  public Registers getRegisters() {
    return registers;
  }

  public void setRegisters(Registers registers) {
    this.registers = registers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AssetIssueRequest assetIssueRequest = (AssetIssueRequest) o;
    return Objects.equals(this.address, assetIssueRequest.address) &&
        Objects.equals(this.ergValue, assetIssueRequest.ergValue) &&
        Objects.equals(this.amount, assetIssueRequest.amount) &&
        Objects.equals(this.name, assetIssueRequest.name) &&
        Objects.equals(this.description, assetIssueRequest.description) &&
        Objects.equals(this.decimals, assetIssueRequest.decimals) &&
        Objects.equals(this.registers, assetIssueRequest.registers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, ergValue, amount, name, description, decimals, registers);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AssetIssueRequest {\n");
    
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    ergValue: ").append(toIndentedString(ergValue)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    decimals: ").append(toIndentedString(decimals)).append("\n");
    sb.append("    registers: ").append(toIndentedString(registers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
