/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockHeader;
import org.ergoplatform.appkit.BlockchainDataSource;
import org.ergoplatform.appkit.BlockchainParameters;
import org.ergoplatform.appkit.BoxOperations;
import org.ergoplatform.appkit.CoveringBoxes;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.PreHeaderBuilder;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.ErgoProverBuilderImpl;
import org.ergoplatform.appkit.impl.PreHeaderBuilderImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionBuilderImpl;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.JSON;

public class BlockchainContextImpl
extends BlockchainContextBase {
    private final BlockchainDataSource _dataSource;
    final BlockchainParameters _blockchainParameters;
    private final List<BlockHeader> _headers;

    public BlockchainContextImpl(BlockchainDataSource blockchainDataSource, NetworkType networkType) {
        super(networkType);
        List<BlockHeader> list = blockchainDataSource.getLastBlockHeaders(10, true);
        BlockchainParameters blockchainParameters = blockchainDataSource.getParameters();
        if (blockchainParameters.getNetworkType() != networkType) {
            throw new IllegalArgumentException("Network type of NodeInfo does not match given networkType - " + (Object)((Object)blockchainParameters.getNetworkType()) + "/" + networkType.verboseName);
        }
        this._dataSource = blockchainDataSource;
        this._blockchainParameters = blockchainParameters;
        this._headers = list;
    }

    @Override
    public PreHeaderBuilder createPreHeader() {
        return new PreHeaderBuilderImpl(this);
    }

    @Override
    public SignedTransaction signedTxFromJson(String string) {
        Gson gson = JSON.createGson().create();
        ErgoTransaction ergoTransaction = (ErgoTransaction)gson.fromJson(string, ErgoTransaction.class);
        ErgoLikeTransaction ergoLikeTransaction = ScalaBridge.isoErgoTransaction().to(ergoTransaction);
        return new SignedTransactionImpl(this, ergoLikeTransaction, 0);
    }

    @Override
    public UnsignedTransactionBuilder newTxBuilder() {
        return new UnsignedTransactionBuilderImpl(this);
    }

    @Override
    public BlockchainDataSource getDataSource() {
        return this._dataSource;
    }

    @Override
    public InputBox[] getBoxesById(String ... stringArray) throws ErgoClientException {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        for (String string : stringArray) {
            arrayList.add(this._dataSource.getBoxById(string, false, false));
        }
        return arrayList.toArray(new InputBox[0]);
    }

    @Override
    public ErgoProverBuilder newProverBuilder() {
        return new ErgoProverBuilderImpl(this);
    }

    @Override
    public int getHeight() {
        return this._headers.get(0).getHeight();
    }

    @Override
    public BlockchainParameters getParameters() {
        return this._blockchainParameters;
    }

    public List<BlockHeader> getHeaders() {
        return this._headers;
    }

    @Override
    public String sendTransaction(SignedTransaction signedTransaction) {
        return this._dataSource.sendTransaction(signedTransaction);
    }

    @Override
    public List<InputBox> getUnspentBoxesFor(Address address, int n, int n2) {
        return this._dataSource.getUnspentBoxesFor(address, n, n2);
    }

    @Override
    public CoveringBoxes getCoveringBoxesFor(Address address, long l, List<ErgoToken> list) {
        return BoxOperations.getCoveringBoxesFor(l, list, false, n -> this._dataSource.getUnspentBoxesFor(address, n * 20, 20));
    }
}

