/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.ergoplatform.restapi.client.SigmaBoolean;
/**
 * SecretProven
 */


public class SecretProven {
  /**
   * Gets or Sets hint
   */
  @JsonAdapter(HintEnum.Adapter.class)
  public enum HintEnum {
    PROOFREAL("proofReal"),
    PROOFSIMULATED("proofSimulated");

    private String value;

    HintEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static HintEnum fromValue(String text) {
      for (HintEnum b : HintEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<HintEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final HintEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public HintEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return HintEnum.fromValue(String.valueOf(value));
      }
    }
  }  @SerializedName("hint")
  private HintEnum hint = null;

  @SerializedName("challenge")
  private String challenge = null;

  @SerializedName("pubkey")
  private SigmaBoolean pubkey = null;

  @SerializedName("proof")
  private String proof = null;

  @SerializedName("position")
  private String position = null;

  public SecretProven hint(HintEnum hint) {
    this.hint = hint;
    return this;
  }

   /**
   * Get hint
   * @return hint
  **/
  @Schema(required = true, description = "")
  public HintEnum getHint() {
    return hint;
  }

  public void setHint(HintEnum hint) {
    this.hint = hint;
  }

  public SecretProven challenge(String challenge) {
    this.challenge = challenge;
    return this;
  }

   /**
   * Get challenge
   * @return challenge
  **/
  @Schema(required = true, description = "")
  public String getChallenge() {
    return challenge;
  }

  public void setChallenge(String challenge) {
    this.challenge = challenge;
  }

  public SecretProven pubkey(SigmaBoolean pubkey) {
    this.pubkey = pubkey;
    return this;
  }

   /**
   * Get pubkey
   * @return pubkey
  **/
  @Schema(required = true, description = "")
  public SigmaBoolean getPubkey() {
    return pubkey;
  }

  public void setPubkey(SigmaBoolean pubkey) {
    this.pubkey = pubkey;
  }

  public SecretProven proof(String proof) {
    this.proof = proof;
    return this;
  }

   /**
   * Get proof
   * @return proof
  **/
  @Schema(required = true, description = "")
  public String getProof() {
    return proof;
  }

  public void setProof(String proof) {
    this.proof = proof;
  }

  public SecretProven position(String position) {
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @Schema(required = true, description = "")
  public String getPosition() {
    return position;
  }

  public void setPosition(String position) {
    this.position = position;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecretProven secretProven = (SecretProven) o;
    return Objects.equals(this.hint, secretProven.hint) &&
        Objects.equals(this.challenge, secretProven.challenge) &&
        Objects.equals(this.pubkey, secretProven.pubkey) &&
        Objects.equals(this.proof, secretProven.proof) &&
        Objects.equals(this.position, secretProven.position);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hint, challenge, pubkey, proof, position);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecretProven {\n");
    
    sb.append("    hint: ").append(toIndentedString(hint)).append("\n");
    sb.append("    challenge: ").append(toIndentedString(challenge)).append("\n");
    sb.append("    pubkey: ").append(toIndentedString(pubkey)).append("\n");
    sb.append("    proof: ").append(toIndentedString(proof)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
