/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.io.IOException;
import org.ergoplatform.appkit.Eip4Token;
import org.ergoplatform.appkit.impl.Eip4TokenBuilder;
import org.ergoplatform.explorer.client.DefaultApi;
import org.junit.Assert;
import org.junit.Test;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Eip4TokenBuilderTest {
    @Test
    public void buildFromExplorerTest() throws IOException {
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.ergoplatform.com/").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        DefaultApi defaultApi = (DefaultApi)retrofit.create(DefaultApi.class);
        Eip4Token eip4Token = Eip4TokenBuilder.buildFromExplorerByTokenId((DefaultApi)defaultApi, (String)"03faf2cb329f2e90d6d23b58d91bbb6c046aa143261cc21f52fbe2824bfcbf04");
        Eip4Token eip4Token2 = Eip4TokenBuilder.buildFromExplorerByTokenId((DefaultApi)defaultApi, (String)"87f5a614e40399c40ad9b2ffe521f9576e34824ddfd29d246f019bb4599866b4");
        Eip4Token eip4Token3 = Eip4TokenBuilder.buildFromExplorerByTokenId((DefaultApi)defaultApi, (String)"6d35874826256ba6f41d896663b5ac461a04264142e46192dd3cd42538c5cee4");
        Eip4Token eip4Token4 = Eip4TokenBuilder.buildFromExplorerByTokenId((DefaultApi)defaultApi, (String)"unusedtokenid");
        Assert.assertNull((Object)eip4Token4);
        Assert.assertNotNull((Object)eip4Token);
        Assert.assertNotNull((Object)eip4Token2);
        Assert.assertNotNull((Object)eip4Token3);
        Assert.assertEquals((Object)Eip4Token.AssetType.NONE, (Object)eip4Token.getAssetType());
        Assert.assertEquals((Object)Eip4Token.AssetType.NFT_PICTURE, (Object)eip4Token2.getAssetType());
        Assert.assertEquals((Object)Eip4Token.AssetType.NFT_AUDIO, (Object)eip4Token3.getAssetType());
        Assert.assertEquals((long)2L, (long)eip4Token.getDecimals());
        Assert.assertEquals((long)0L, (long)eip4Token2.getDecimals());
        Assert.assertTrue((boolean)eip4Token2.isNftAssetType());
        Assert.assertTrue((boolean)eip4Token3.isNftAssetType());
        Assert.assertFalse((boolean)eip4Token.isNftAssetType());
        Assert.assertNotNull((Object)eip4Token2.getNftContentHash());
        Assert.assertNotNull((Object)eip4Token3.getNftContentHash());
        Assert.assertNull((Object)eip4Token.getNftContentHash());
        Assert.assertNull((Object)eip4Token.getNftContentLink());
        Assert.assertEquals((Object)"ipfs://bafybeieswxwp6hzu36pu7pznwybcnopl4wwrfsny4ag4b6rwkcm7rpjeyq", (Object)eip4Token2.getNftContentLink());
        Assert.assertEquals((Object)"ipfs://bafybeih5aigkrqiopylhvv24utehjb3optd3xhaxlheh7n6de4kloulfma", (Object)eip4Token3.getNftContentLink());
        Assert.assertNull((Object)eip4Token.getNftCoverImageLink());
        Assert.assertNull((Object)eip4Token2.getNftCoverImageLink());
        Assert.assertEquals((Object)"ipfs://bafkreigzktykbpkbpknofphvmae2z2bwzqdg3artn26nnxr7akal7lnm2m", (Object)eip4Token3.getNftCoverImageLink());
    }

    @Test
    public void buildNftPictureTest() {
        Eip4Token eip4Token = Eip4TokenBuilder.buildNftPictureToken((String)"87f5a614e40399c40ad9b2ffe521f9576e34824ddfd29d246f019bb4599866b4", (long)1L, (String)"Test NFT", (String)"Description for Pic NFT", (int)0, (byte[])new byte[256], null);
        String string = "https://test.link";
        Eip4Token eip4Token2 = Eip4TokenBuilder.buildNftPictureToken((String)"87f5a614e40399c40ad9b2ffe521f9576e34824ddfd29d246f019bb4599866b4", (long)1L, (String)"Test NFT", (String)"", (int)0, (byte[])new byte[256], (String)string);
        Assert.assertNotNull((Object)eip4Token);
        Assert.assertNotNull((Object)eip4Token2);
        Assert.assertEquals((Object)Eip4Token.AssetType.NFT_PICTURE, (Object)eip4Token.getAssetType());
        Assert.assertEquals((Object)Eip4Token.AssetType.NFT_PICTURE, (Object)eip4Token2.getAssetType());
        Assert.assertEquals((long)0L, (long)eip4Token.getDecimals());
        Assert.assertTrue((boolean)eip4Token.isNftAssetType());
        Assert.assertTrue((boolean)eip4Token2.isNftAssetType());
        Assert.assertNotNull((Object)eip4Token.getNftContentHash());
        Assert.assertNotNull((Object)eip4Token2.getNftContentHash());
        Assert.assertNull((Object)eip4Token.getNftContentLink());
        Assert.assertEquals((Object)string, (Object)eip4Token2.getNftContentLink());
        Assert.assertNull((Object)eip4Token.getNftCoverImageLink());
        Assert.assertNull((Object)eip4Token2.getNftCoverImageLink());
        Assert.assertTrue((boolean)eip4Token2.getTokenDescription().isEmpty());
    }

    @Test
    public void buildNftAudioTest() {
        Eip4Token eip4Token = Eip4TokenBuilder.buildNftAudioToken((String)"6d35874826256ba6f41d896663b5ac461a04264142e46192dd3cd42538c5cee4", (long)1L, (String)"Test NFT", (String)"Description for Audio NFT", (int)0, (byte[])new byte[256], (String)"linkToAudio", (String)"linkToCover");
        Eip4Token eip4Token2 = Eip4TokenBuilder.buildNftAudioToken((String)"6d35874826256ba6f41d896663b5ac461a04264142e46192dd3cd42538c5cee4", (long)1L, (String)"Test NFT", (String)"Description for Audio NFT", (int)0, (byte[])new byte[256], (String)"linkToAudio", null);
        Assert.assertNotNull((Object)eip4Token);
        Assert.assertNotNull((Object)eip4Token2);
        Assert.assertEquals((Object)Eip4Token.AssetType.NFT_AUDIO, (Object)eip4Token.getAssetType());
        Assert.assertEquals((Object)Eip4Token.AssetType.NFT_AUDIO, (Object)eip4Token2.getAssetType());
        Assert.assertEquals((long)0L, (long)eip4Token.getDecimals());
        Assert.assertTrue((boolean)eip4Token.isNftAssetType());
        Assert.assertTrue((boolean)eip4Token2.isNftAssetType());
        Assert.assertNotNull((Object)eip4Token.getNftContentHash());
        Assert.assertNotNull((Object)eip4Token2.getNftContentHash());
        Assert.assertNotNull((Object)eip4Token.getNftContentLink());
        Assert.assertNotNull((Object)eip4Token2.getNftContentLink());
        Assert.assertNotNull((Object)eip4Token.getNftCoverImageLink());
        Assert.assertNull((Object)eip4Token2.getNftCoverImageLink());
    }

    @Test
    public void buildNftArtworkCollectionTokenTest() {
        Eip4Token eip4Token = Eip4TokenBuilder.buildNftArtworkCollectionToken((String)"6d35874826256ba6f41d896663b5ac461a04264142e46192dd3cd42538c5cee4", (long)1L, (String)"Collection Test Token", (String)"Description for Collection Test Token", (int)0);
        Assert.assertNotNull((Object)eip4Token);
        Assert.assertEquals((Object)Eip4Token.AssetType.ARTWORK_COLLECTION, (Object)eip4Token.getAssetType());
        Assert.assertEquals((long)0L, (long)eip4Token.getDecimals());
        Assert.assertTrue((boolean)eip4Token.isNftAssetType());
        Assert.assertNull((Object)eip4Token.getNftContentLink());
        Assert.assertNull((Object)eip4Token.getNftCoverImageLink());
    }
}

