/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BlockchainDataSource;
import org.ergoplatform.appkit.BoxOperations;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Transaction;
import org.ergoplatform.sdk.ErgoToken;

public class ExplorerAndPoolUnspentBoxesLoader
extends BoxOperations.ExplorerApiWithCheckerLoader {
    private final List<String> unconfirmedSpentBoxesIds = new ArrayList<String>();
    private boolean unconfirmedBoxesFetched;
    private boolean allowChainedTx = false;

    public ExplorerAndPoolUnspentBoxesLoader withAllowChainedTx(boolean bl) {
        this.allowChainedTx = bl;
        return this;
    }

    @Override
    public void prepare(@Nonnull BlockchainContext blockchainContext, List<Address> list, long l, @Nonnull List<ErgoToken> list2) {
        this.unconfirmedSpentBoxesIds.clear();
        BlockchainDataSource blockchainDataSource = blockchainContext.getDataSource();
        List<Transaction> list3 = blockchainDataSource.getUnconfirmedTransactions(0, 1000);
        for (Transaction transaction : list3) {
            this.unconfirmedSpentBoxesIds.addAll(transaction.getInputBoxesIds());
        }
    }

    @Override
    public void prepareForAddress(Address address) {
        this.unconfirmedBoxesFetched = false;
    }

    @Override
    protected boolean canUseBox(InputBox inputBox) {
        return !this.unconfirmedSpentBoxesIds.contains(inputBox.getId().toString());
    }

    @Override
    @Nonnull
    public List<InputBox> loadBoxesPage(@Nonnull BlockchainContext blockchainContext, @Nonnull Address address, @Nonnull Integer n) {
        List<InputBox> list = super.loadBoxesPage(blockchainContext, address, n);
        if (list.isEmpty() && this.allowChainedTx && !this.unconfirmedBoxesFetched) {
            this.unconfirmedBoxesFetched = true;
            try {
                list.addAll(blockchainContext.getDataSource().getUnconfirmedUnspentBoxesFor(address, 0, 50));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }
}

