/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ergoplatform.sdk.ErgoToken;

public class SelectTokensHelper {
    private final HashMap<String, Long> tokensLeft = new HashMap();
    private boolean changeBoxNeeded;

    public SelectTokensHelper(Iterable<ErgoToken> iterable) {
        for (ErgoToken ergoToken : iterable) {
            this.tokensLeft.put(ergoToken.getId().toString(), ergoToken.getValue());
        }
        this.changeBoxNeeded = false;
    }

    public boolean areTokensNeeded(Iterable<ErgoToken> iterable) {
        boolean bl = false;
        for (ErgoToken ergoToken : iterable) {
            Long l;
            String string = ergoToken.getId().toString();
            if (!this.tokensLeft.containsKey(string) || (l = this.tokensLeft.get(string)) <= 0L) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public SelectTokensHelper useTokens(Iterable<ErgoToken> iterable) {
        for (ErgoToken ergoToken : iterable) {
            String string = ergoToken.getId().toString();
            if (this.tokensLeft.containsKey(string)) {
                Long l = this.tokensLeft.get(string);
                long l2 = l - ergoToken.getValue();
                this.tokensLeft.put(string, l2);
                if (l2 >= 0L) continue;
                this.changeBoxNeeded = true;
                continue;
            }
            this.changeBoxNeeded = true;
        }
        return this;
    }

    public boolean areTokensCovered() {
        boolean bl = true;
        for (Long l : this.tokensLeft.values()) {
            if (l <= 0L) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public List<ErgoToken> getRemainingTokenList() {
        ArrayList<ErgoToken> arrayList = new ArrayList<ErgoToken>();
        for (Map.Entry<String, Long> entry : this.tokensLeft.entrySet()) {
            long l = entry.getValue();
            if (l <= 0L) continue;
            arrayList.add(new ErgoToken(entry.getKey(), l));
        }
        return arrayList;
    }

    public boolean isChangeBoxNeeded() {
        return this.changeBoxNeeded;
    }
}

