/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.commands;

import java.io.File;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.cli.CmdLineParser$;
import org.ergoplatform.appkit.commands.AddressPType$;
import org.ergoplatform.appkit.commands.CmdArgParser;
import org.ergoplatform.appkit.commands.CmdDescriptor;
import org.ergoplatform.appkit.commands.CmdParameter;
import org.ergoplatform.appkit.commands.CommandNamePType$;
import org.ergoplatform.appkit.commands.DirPathPType$;
import org.ergoplatform.appkit.commands.EnumPType;
import org.ergoplatform.appkit.commands.EnumParser;
import org.ergoplatform.appkit.commands.ErgoIdPType$;
import org.ergoplatform.appkit.commands.FilePType$;
import org.ergoplatform.appkit.commands.IntPType$;
import org.ergoplatform.appkit.commands.LongPType$;
import org.ergoplatform.appkit.commands.NetworkPType$;
import org.ergoplatform.appkit.commands.PType;
import org.ergoplatform.appkit.commands.SecretStringPType$;
import org.ergoplatform.appkit.commands.StringPType$;
import org.ergoplatform.appkit.commands.package$;
import org.ergoplatform.sdk.ErgoId$;
import org.ergoplatform.sdk.SecretString$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class DefaultCmdArgParser$
extends CmdArgParser {
    public static DefaultCmdArgParser$ MODULE$;

    static {
        new DefaultCmdArgParser$();
    }

    @Override
    public Object parse(CmdDescriptor cmd, CmdParameter p, String rawArg) {
        Object object;
        PType pType = p.tpe();
        boolean bl = CommandNamePType$.MODULE$.equals(pType) ? true : StringPType$.MODULE$.equals(pType);
        if (bl) {
            object = rawArg;
        } else if (NetworkPType$.MODULE$.equals(pType)) {
            NetworkType networkType = CmdLineParser$.MODULE$.parseNetwork(rawArg);
            object = networkType;
        } else if (SecretStringPType$.MODULE$.equals(pType)) {
            object = SecretString$.MODULE$.create(rawArg);
        } else if (IntPType$.MODULE$.equals(pType)) {
            object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(rawArg)).toInt());
        } else if (LongPType$.MODULE$.equals(pType)) {
            object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(rawArg)).toLong());
        } else if (AddressPType$.MODULE$.equals(pType)) {
            object = Address.create(rawArg);
        } else if (ErgoIdPType$.MODULE$.equals(pType)) {
            object = ErgoId$.MODULE$.create(rawArg);
        } else if (FilePType$.MODULE$.equals(pType)) {
            File storageFile = new File(rawArg);
            if (!storageFile.exists()) {
                throw package$.MODULE$.usageError(new StringBuilder(29).append("Specified file is not found: ").append(storageFile).toString(), (Option<CmdDescriptor>)new Some((Object)cmd));
            }
            object = storageFile;
        } else if (DirPathPType$.MODULE$.equals(pType)) {
            File file = new File(rawArg);
            if (!file.exists()) {
                throw package$.MODULE$.usageError(new StringBuilder(50).append("Invalid parameter '").append(p.name()).append("': directory '").append(file).append("' doesn't exists.").toString(), (Option<CmdDescriptor>)new Some((Object)cmd));
            }
            if (!file.isDirectory()) {
                throw package$.MODULE$.usageError(new StringBuilder(42).append("Invalid parameter '").append(p.name()).append("': '").append(file).append("' is not directory.").toString(), (Option<CmdDescriptor>)new Some((Object)cmd));
            }
            object = file.toPath();
        } else if (pType instanceof EnumPType) {
            EnumPType enumPType = (EnumPType)pType;
            EnumParser parser = new EnumParser(enumPType);
            object = parser.parse(cmd, p, rawArg);
        } else {
            throw package$.MODULE$.usageError(new StringBuilder(28).append("Unsupported parameter type: ").append(p.tpe()).toString(), (Option<CmdDescriptor>)new Some((Object)cmd));
        }
        return object;
    }

    private DefaultCmdArgParser$() {
        MODULE$ = this;
    }
}

